/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;

public class RowType
extends InternalType {
    private static final long serialVersionUID = 1L;
    private final DataType[] types;
    private final String[] fieldNames;

    public RowType(DataType ... types) {
        this(types, RowType.getFieldNames(types.length));
    }

    public RowType(DataType[] types, String[] fieldNames) {
        this.types = types;
        this.fieldNames = fieldNames;
    }

    private static String[] getFieldNames(int length) {
        String[] fieldNames = new String[length];
        for (int i = 0; i < length; ++i) {
            fieldNames[i] = "f" + i;
        }
        return fieldNames;
    }

    public int getArity() {
        return this.types.length;
    }

    public DataType[] getFieldTypes() {
        return this.types;
    }

    public InternalType[] getFieldInternalTypes() {
        return (InternalType[])Arrays.stream(this.types).map(DataType::toInternalType).toArray(InternalType[]::new);
    }

    public InternalType getInternalTypeAt(int i) {
        return this.types[i].toInternalType();
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowType that = (RowType)o;
        return Arrays.equals(this.getFieldInternalTypes(), that.getFieldInternalTypes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    public String toString() {
        return "RowType{, types=" + Arrays.toString(this.getFieldInternalTypes()) + ", fieldNames=" + Arrays.toString(this.fieldNames) + '}';
    }
}

