/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BinaryArraySerializer;
import org.apache.flink.table.typeutils.TypeUtils;
import org.apache.flink.util.InstantiationUtil;

public class BaseArraySerializer
extends TypeSerializer<BaseArray> {
    private final boolean isPrimitive;
    private final InternalType eleType;
    private final Class<?> internalEleClass;
    private TypeSerializer elementSerializer;
    private BinaryArraySerializer binarySerializer;
    private BinaryArray reuseBinaryArray;
    private BinaryArrayWriter reuseBinaryWriter;

    public BaseArraySerializer(boolean isPrimitive, InternalType eleType) {
        this.isPrimitive = isPrimitive;
        this.eleType = eleType;
        this.internalEleClass = isPrimitive ? TypeUtils.getPrimitiveInternalClassForType(eleType) : TypeUtils.getInternalClassForType(eleType);
        this.elementSerializer = DataTypes.createInternalSerializer(eleType);
        this.binarySerializer = BinaryArraySerializer.INSTANCE;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public InternalType getElementType() {
        return this.eleType;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<BaseArray> duplicate() {
        return new BaseArraySerializer(this.isPrimitive, this.eleType);
    }

    @Override
    public BaseArray createInstance() {
        return new GenericArray(0, this.isPrimitive, this.internalEleClass);
    }

    @Override
    public BaseArray copy(BaseArray from) {
        return this.copy(from, new GenericArray(from.numElements(), this.isPrimitive, this.internalEleClass));
    }

    @Override
    public BaseArray copy(BaseArray from, BaseArray reuse) {
        int numElements = from.numElements();
        GenericArray ret = reuse instanceof GenericArray ? (GenericArray)reuse : new GenericArray(numElements, this.isPrimitive, this.internalEleClass);
        for (int i = 0; i < numElements; ++i) {
            if (from.isNullAt(i)) {
                ret.setNullAt(i);
                continue;
            }
            ret.setNotNullAt(i);
            if (this.isPrimitive) {
                ret.setPrimitive(i, TypeGetterSetters.get(from, i, this.eleType), this.eleType);
                continue;
            }
            Object element = TypeGetterSetters.get(from, i, this.eleType);
            if (from instanceof GenericArray) {
                element = this.elementSerializer.copy(element);
            }
            ret.setObject(i, element);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BaseArray record, DataOutputView target) throws IOException {
        BinaryArray binaryArray = this.baseArrayToBinary(record);
        target.write(binaryArray.getBytes());
    }

    public BinaryArray baseArrayToBinary(BaseArray from) {
        if (from instanceof BinaryArray) {
            return (BinaryArray)from;
        }
        int numElements = from.numElements();
        if (this.reuseBinaryArray == null) {
            this.reuseBinaryArray = new BinaryArray();
        }
        if (this.reuseBinaryWriter == null || this.reuseBinaryWriter.getNumElements() != numElements) {
            this.reuseBinaryWriter = new BinaryArrayWriter(this.reuseBinaryArray, numElements, BinaryArray.calculateElementSize(this.eleType));
        } else {
            this.reuseBinaryWriter.reset();
        }
        for (int i = 0; i < numElements; ++i) {
            if (from.isNullAt(i)) {
                this.reuseBinaryWriter.setNullAt(i, this.eleType);
                continue;
            }
            BaseRowUtil.write(this.reuseBinaryWriter, i, TypeGetterSetters.get(from, i, this.eleType), this.eleType, this.elementSerializer);
        }
        this.reuseBinaryWriter.complete();
        return this.reuseBinaryArray;
    }

    @Override
    public BaseArray deserialize(DataInputView source) throws IOException {
        return this.binarySerializer.deserialize(source);
    }

    @Override
    public BaseArray deserialize(BaseArray reuse, DataInputView source) throws IOException {
        if (reuse instanceof BinaryArray) {
            return this.binarySerializer.deserialize((BinaryArray)reuse, source);
        }
        return this.binarySerializer.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            BaseArraySerializer other = (BaseArraySerializer)obj;
            return this.isPrimitive == other.isPrimitive() && this.eleType.equals(other.getElementType());
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseArraySerializer;
    }

    @Override
    public int hashCode() {
        return 31 * this.eleType.hashCode() + (this.isPrimitive ? 1 : 0);
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ArraySerializerConfigSnapshot(this.isPrimitive, this.eleType, this.elementSerializer, this.binarySerializer);
    }

    @Override
    public CompatibilityResult<BaseArray> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (!(configSnapshot instanceof ArraySerializerConfigSnapshot)) {
            return CompatibilityResult.requiresMigration();
        }
        ArraySerializerConfigSnapshot config = (ArraySerializerConfigSnapshot)configSnapshot;
        if (config.isPrimitive() != this.isPrimitive || !config.getElementType().equals(this.eleType)) {
            return CompatibilityResult.requiresMigration();
        }
        TypeSerializer[] serializers = new TypeSerializer[]{this.elementSerializer, this.binarySerializer};
        List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousFieldSerializersAndConfigs = ((AbstractRowSerializer.RowSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
        if (previousFieldSerializersAndConfigs.size() != serializers.length) {
            return CompatibilityResult.requiresMigration();
        }
        for (int i = 0; i < serializers.length; ++i) {
            CompatibilityResult compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousFieldSerializersAndConfigs.get((int)i).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousFieldSerializersAndConfigs.get((int)i).f1, serializers[i]);
            if (!compatResult.isRequiresMigration()) continue;
            return CompatibilityResult.requiresMigration();
        }
        return CompatibilityResult.compatible();
    }

    public static final class ArraySerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;
        private boolean isPrimitive;
        private InternalType eleType;

        public ArraySerializerConfigSnapshot(boolean isPrimitive, InternalType eleType, TypeSerializer elementSerializer, BinaryArraySerializer binarySerializer) {
            super(elementSerializer, binarySerializer);
            this.isPrimitive = isPrimitive;
            this.eleType = eleType;
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(out);){
                InstantiationUtil.serializeObject(outViewWrapper, this.isPrimitive);
                InstantiationUtil.serializeObject(outViewWrapper, this.eleType);
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            super.read(in);
            try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
                this.isPrimitive = (Boolean)InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader());
                this.eleType = (InternalType)InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new IOException("Could not find requested element class in classpath.", e2);
            }
        }

        @Override
        public int getVersion() {
            return 1;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public InternalType getElementType() {
            return this.eleType;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ArraySerializerConfigSnapshot) {
                ArraySerializerConfigSnapshot other = (ArraySerializerConfigSnapshot)obj;
                return super.equals(obj) && this.isPrimitive == other.isPrimitive() && this.eleType.equals(other.getElementType());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 31 * (31 * super.hashCode() + this.eleType.hashCode()) + (this.isPrimitive ? 1 : 0);
        }
    }
}

