/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseArraySerializer;
import org.apache.flink.table.typeutils.BinaryMapSerializer;

public class BaseMapSerializer
extends TypeSerializer<BaseMap> {
    private final InternalType keyType;
    private final InternalType valueType;
    private final TypeSerializer keySerializer;
    private final TypeSerializer valueSerializer;
    private final BinaryMapSerializer binarySerializer;
    private BinaryArray reuseKeyArray;
    private BinaryArray reuseValueArray;
    private BinaryArrayWriter reuseKeyWriter;
    private BinaryArrayWriter reuseValueWriter;

    public BaseMapSerializer(InternalType keyType, InternalType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySerializer = DataTypes.createInternalSerializer(keyType);
        this.valueSerializer = DataTypes.createInternalSerializer(valueType);
        this.binarySerializer = BinaryMapSerializer.INSTANCE;
    }

    public InternalType getKeyType() {
        return this.keyType;
    }

    public InternalType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<BaseMap> duplicate() {
        return null;
    }

    @Override
    public BaseMap createInstance() {
        return new GenericMap();
    }

    @Override
    public BaseMap copy(BaseMap from) {
        return this.copy(from, null);
    }

    @Override
    public BaseMap copy(BaseMap from, BaseMap reuse) {
        if (from instanceof GenericMap) {
            Map fromMap = from.toJavaMap(this.keyType, this.valueType);
            HashMap toMap = new HashMap();
            for (Map.Entry entry : fromMap.entrySet()) {
                toMap.put(this.keySerializer.copy(entry.getKey()), this.valueSerializer.copy(entry.getValue()));
            }
            return new GenericMap(toMap);
        }
        return new GenericMap(from.toJavaMap(this.keyType, this.valueType));
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BaseMap record, DataOutputView target) throws IOException {
        BinaryMap binaryMap = this.baseMapToBinary(record);
        target.write(binaryMap.getBytes());
    }

    public BinaryMap baseMapToBinary(BaseMap from) {
        if (from instanceof BinaryMap) {
            return (BinaryMap)from;
        }
        Map javaMap = from.toJavaMap(this.keyType, this.valueType);
        int numElements = javaMap.size();
        if (this.reuseKeyArray == null) {
            this.reuseKeyArray = new BinaryArray();
        }
        if (this.reuseValueArray == null) {
            this.reuseValueArray = new BinaryArray();
        }
        if (this.reuseKeyWriter == null || this.reuseKeyWriter.getNumElements() != numElements) {
            this.reuseKeyWriter = new BinaryArrayWriter(this.reuseKeyArray, numElements, BinaryArray.calculateElementSize(this.keyType));
        } else {
            this.reuseKeyWriter.reset();
        }
        if (this.reuseValueWriter == null || this.reuseValueWriter.getNumElements() != numElements) {
            this.reuseValueWriter = new BinaryArrayWriter(this.reuseValueArray, numElements, BinaryArray.calculateElementSize(this.valueType));
        } else {
            this.reuseValueWriter.reset();
        }
        int i = 0;
        for (Map.Entry entry : javaMap.entrySet()) {
            if (entry.getKey() == null) {
                this.reuseKeyWriter.setNullAt(i, this.keyType);
            } else {
                BaseRowUtil.write(this.reuseKeyWriter, i, entry.getKey(), this.keyType, this.keySerializer);
            }
            if (entry.getValue() == null) {
                this.reuseValueWriter.setNullAt(i, this.valueType);
            } else {
                BaseRowUtil.write(this.reuseValueWriter, i, entry.getValue(), this.valueType, this.valueSerializer);
            }
            ++i;
        }
        this.reuseKeyWriter.complete();
        this.reuseValueWriter.complete();
        return BinaryMap.valueOf(this.reuseKeyArray, this.reuseValueArray);
    }

    @Override
    public BaseMap deserialize(DataInputView source) throws IOException {
        return this.binarySerializer.deserialize(source);
    }

    @Override
    public BaseMap deserialize(BaseMap reuse, DataInputView source) throws IOException {
        if (reuse instanceof BinaryMap) {
            return this.binarySerializer.deserialize((BinaryMap)reuse, source);
        }
        return this.binarySerializer.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            BaseMapSerializer other = (BaseMapSerializer)obj;
            return this.keyType.equals(other.getKeyType()) && this.valueType.equals(other.getValueType());
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseMapSerializer;
    }

    @Override
    public int hashCode() {
        return 31 * this.keyType.hashCode() + this.valueType.hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new CompositeTypeSerializerConfigSnapshot(new TypeSerializer[]{this.keySerializer, this.valueSerializer, this.binarySerializer}){
            private static final int VERSION = 1;

            @Override
            public int getVersion() {
                return 1;
            }
        };
    }

    @Override
    public CompatibilityResult<BaseMap> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (!(configSnapshot instanceof BaseArraySerializer.ArraySerializerConfigSnapshot)) {
            return CompatibilityResult.requiresMigration();
        }
        TypeSerializer[] serializers = new TypeSerializer[]{this.keySerializer, this.valueSerializer, this.binarySerializer};
        List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousFieldSerializersAndConfigs = ((AbstractRowSerializer.RowSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
        if (previousFieldSerializersAndConfigs.size() != serializers.length) {
            return CompatibilityResult.requiresMigration();
        }
        for (int i = 0; i < serializers.length; ++i) {
            CompatibilityResult compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousFieldSerializersAndConfigs.get((int)i).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousFieldSerializersAndConfigs.get((int)i).f1, serializers[i]);
            if (!compatResult.isRequiresMigration()) continue;
            return CompatibilityResult.requiresMigration();
        }
        return CompatibilityResult.compatible();
    }
}

