/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.codegen.CodeGenUtils;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.GeneratedProjection;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BoxedWrapperRow;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.NestedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.types.CopyableValue;

public class BaseRowSerializer<T extends BaseRow>
extends AbstractRowSerializer<T> {
    protected BinaryRowSerializer binarySerializer;
    private Class<T> rowType;
    private transient Projection<BaseRow, BinaryRow> projection;

    public BaseRowSerializer(TypeInformation<?> ... types) {
        this(BaseRow.class, types);
    }

    public BaseRowSerializer(InternalType ... types) {
        this(BaseRow.class, BaseRowSerializer.toTypeInfos(types));
    }

    private static TypeInformation[] toTypeInfos(InternalType ... types) {
        TypeInformation[] typeInfos = new TypeInformation[types.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            typeInfos[i] = TypeConverters.createExternalTypeInfoFromDataType(types[i]);
        }
        return typeInfos;
    }

    public BaseRowSerializer(Class<T> rowType, InternalType[] types) {
        this(rowType, BaseRowSerializer.toTypeInfos(types));
    }

    public BaseRowSerializer(Class<T> rowType, TypeInformation<?> ... types) {
        super(types);
        this.rowType = rowType;
        this.binarySerializer = new BinaryRowSerializer(types);
    }

    public static GeneratedProjection genProjection(TypeInformation[] types) {
        BaseRowTypeInfo baseType = new BaseRowTypeInfo(types);
        int[] mapping = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            mapping[i] = i;
        }
        return ProjectionCodeGenerator.generateProjection(CodeGeneratorContext.apply(null, false), "BaseRowSerializerProjection", (RowType)TypeConverters.createInternalTypeFromTypeInfo(baseType), (RowType)TypeConverters.createInternalTypeFromTypeInfo(new BaseRowTypeInfo(types)), mapping);
    }

    public Projection<BaseRow, BinaryRow> getProjection() throws IOException {
        if (this.projection == null) {
            try {
                GeneratedProjection gProjection = BaseRowSerializer.genProjection(this.types);
                this.projection = (Projection)CodeGenUtils.compile(Thread.currentThread().getContextClassLoader(), gProjection.name(), gProjection.code()).newInstance();
            }
            catch (Exception e2) {
                throw new IOException(e2);
            }
        }
        return this.projection;
    }

    @Override
    public TypeSerializer<T> duplicate() {
        return new BaseRowSerializer<T>(this.rowType, this.types);
    }

    @Override
    public T createInstance() {
        if (this.rowType.equals(GenericRow.class)) {
            return (T)new GenericRow(this.getNumFields());
        }
        if (this.rowType.equals(BoxedWrapperRow.class)) {
            return (T)new BoxedWrapperRow(this.getNumFields());
        }
        if (this.rowType.equals(ColumnarRow.class)) {
            return (T)new ColumnarRow();
        }
        return (T)new BinaryRow(this.getNumFields());
    }

    @Override
    public T copy(T from) {
        if (from.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from.getClass() == BinaryRow.class) {
            return (T)((BinaryRow)from).copy();
        }
        if (from.getClass() == BoxedWrapperRow.class) {
            return (T)this.copyBoxedWrapperRow((BoxedWrapperRow)from, new BoxedWrapperRow(from.getArity()));
        }
        if (from.getClass() == NestedRow.class) {
            return (T)this.copyNestedRow((NestedRow)from, new NestedRow(from.getArity()));
        }
        return (T)this.copyBaseRow((BaseRow)from, new GenericRow(from.getArity()));
    }

    @Override
    public T copy(T from, T reuse) {
        if (from.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from.getClass() == BinaryRow.class) {
            return (T)((BinaryRow)from).copy((BaseRow)reuse);
        }
        if (from.getClass() == BoxedWrapperRow.class) {
            return (T)this.copyBoxedWrapperRow((BoxedWrapperRow)from, (BaseRow)reuse);
        }
        if (from.getClass() == NestedRow.class) {
            return (T)this.copyNestedRow((NestedRow)from, (NestedRow)reuse);
        }
        return (T)this.copyBaseRow((BaseRow)from, (BaseRow)reuse);
    }

    private BaseRow copyBaseRow(BaseRow from, BaseRow reuse) {
        GenericRow ret = reuse instanceof GenericRow ? (GenericRow)reuse : new GenericRow(from.getArity());
        ret.setHeader(from.getHeader());
        for (int i = 0; i < from.getArity(); ++i) {
            if (!from.isNullAt(i)) {
                ret.update(i, this.copyValueNotNull(BaseRowUtil.get(from, i, this.types[i], this.serializers[i]), i));
                continue;
            }
            ret.setNullAt(i);
        }
        return ret;
    }

    private Object copyValueNotNull(Object o, int index) {
        if (o instanceof BinaryString) {
            return ((BinaryString)o).copy();
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof BinaryArray) {
            return ((BinaryArray)o).copy();
        }
        if (o instanceof BinaryMap) {
            return ((BinaryMap)o).copy();
        }
        return this.serializers[index].copy(o);
    }

    private BaseRow copyBoxedWrapperRow(BoxedWrapperRow from, BaseRow reuse) {
        GenericRow ret = reuse instanceof GenericRow ? (GenericRow)reuse : new GenericRow(from.getArity());
        ret.setHeader(from.getHeader());
        for (int i = 0; i < from.getArity(); ++i) {
            if (!from.isNullAt(i)) {
                ret.update(i, this.copyNotNullFromBoxedWrapperRow(BaseRowUtil.get(from, i, this.types[i], this.serializers[i]), i));
                continue;
            }
            ret.setNullAt(i);
        }
        return ret;
    }

    private Object copyNotNullFromBoxedWrapperRow(Object o, int index) {
        if (o instanceof CopyableValue) {
            return ((CopyableValue)o).copy();
        }
        return this.copyValueNotNull(o, index);
    }

    private BaseRow copyNestedRow(NestedRow from, NestedRow reuse) {
        byte[] bytes = BinaryRowUtil.copy(from.getSegments(), from.getBaseOffset(), from.getSizeInBytes());
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, from.getSizeInBytes());
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public BinaryRow baseRowToBinary(BaseRow baseRow) throws IOException {
        BinaryRow row2 = this.getProjection().apply(baseRow);
        row2.setHeader(baseRow.getHeader());
        return row2;
    }

    @Override
    public void serialize(BaseRow row2, DataOutputView target) throws IOException {
        BinaryRow binaryRow = row2.getClass() == BinaryRow.class ? (BinaryRow)row2 : this.baseRowToBinary(row2);
        this.binarySerializer.serialize(binaryRow, target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return (T)this.binarySerializer.deserialize(source);
    }

    @Override
    public T deserialize(BaseRow reuse, DataInputView source) throws IOException {
        if (reuse instanceof BinaryRow) {
            return (T)this.binarySerializer.deserialize((BinaryRow)reuse, source);
        }
        return (T)this.binarySerializer.deserialize(source);
    }

    @Override
    public int serializeToPages(BaseRow row2, AbstractPagedOutputView target) throws IOException {
        return this.binarySerializer.serializeToPages(this.baseRowToBinary(row2), target);
    }

    @Override
    public T deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public T deserializeFromPages(T reuse, AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public T mapFromPages(AbstractPagedInputView source) throws IOException {
        return (T)this.binarySerializer.mapFromPages(source);
    }

    @Override
    public T mapFromPages(T reuse, AbstractPagedInputView source) throws IOException {
        if (reuse instanceof BinaryRow) {
            return (T)this.binarySerializer.mapFromPages((BinaryRow)reuse, source);
        }
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            BaseRowSerializer other = (BaseRowSerializer)obj;
            return Arrays.equals(this.types, other.types);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseRowSerializer;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public int getLength() {
        return -1;
    }

    private BinaryRowSerializer createBinaryRowSerializer() {
        return new BinaryRowSerializer(this.getTypes());
    }
}

