/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowComparator;
import org.apache.flink.table.typeutils.BaseRowSerializer;
import org.apache.flink.util.Preconditions;

public class BaseRowTypeInfo
extends TupleTypeInfoBase<BaseRow> {
    private static final long serialVersionUID = 1L;
    protected final String[] fieldNames;

    public BaseRowTypeInfo(TypeInformation<?> ... types) {
        this(types, BaseRowTypeInfo.getFieldNames(types));
    }

    public BaseRowTypeInfo(TypeInformation<?>[] types, String[] fieldNames) {
        super(BaseRow.class, types);
        Preconditions.checkNotNull(fieldNames, "FieldNames should not be null.");
        Preconditions.checkArgument(types.length == fieldNames.length, "Number of field types and names is different.");
        Preconditions.checkArgument(!this.hasDuplicateFieldNames(fieldNames), "Field names are not unique.");
        this.fieldNames = Arrays.copyOf(fieldNames, fieldNames.length);
    }

    @Deprecated
    public BaseRowTypeInfo(Class<?> clazz, TypeInformation<?>[] types, String[] fieldNames) {
        this(types, fieldNames);
    }

    private static String[] getFieldNames(TypeInformation<?>[] types) {
        String[] fieldNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            fieldNames[i] = "f" + i;
        }
        return fieldNames;
    }

    @Override
    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public TypeComparator<BaseRow> createComparator(int[] logicalKeyFields, boolean[] orders, int logicalFieldOffset, ExecutionConfig config) {
        return new BaseRowComparator(this.types, orders[0]);
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseRowTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.fieldNames);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("Row");
        if (this.types.length > 0) {
            bld.append('(').append(this.fieldNames[0]).append(": ").append(this.types[0]);
            for (int i = 1; i < this.types.length; ++i) {
                bld.append(", ").append(this.fieldNames[i]).append(": ").append(this.types[i]);
            }
            bld.append(')');
        }
        return bld.toString();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.types;
    }

    private boolean hasDuplicateFieldNames(String[] fieldNames) {
        HashSet<String> names = new HashSet<String>();
        for (String field : fieldNames) {
            if (names.add(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompositeType.TypeComparatorBuilder<BaseRow> createTypeComparatorBuilder() {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public TypeSerializer<BaseRow> createSerializer(ExecutionConfig config) {
        return this.createSerializer();
    }

    public AbstractRowSerializer<BaseRow> createSerializer() {
        return new BaseRowSerializer<BaseRow>(this.getTypeClass(), this.types);
    }

    public RowType toInternalType() {
        return (RowType)TypeConverters.createInternalTypeFromTypeInfo(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseRowTypeInfo) {
            BaseRowTypeInfo other = (BaseRowTypeInfo)obj;
            return Arrays.equals(this.types, other.types);
        }
        return false;
    }
}

