/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryMap;

public class BinaryMapSerializer
extends TypeSerializerSingleton<BinaryMap> {
    public static final BinaryMapSerializer INSTANCE = new BinaryMapSerializer();

    private BinaryMapSerializer() {
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public BinaryMap createInstance() {
        return new BinaryMap();
    }

    @Override
    public BinaryMap copy(BinaryMap from) {
        return from.copy();
    }

    @Override
    public BinaryMap copy(BinaryMap from, BinaryMap reuse) {
        return from.copy(reuse);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryMap record, DataOutputView target) throws IOException {
        byte[] bytes = record.getBytes();
        target.write(bytes.length);
        target.write(bytes);
    }

    @Override
    public BinaryMap deserialize(DataInputView source) throws IOException {
        return this.deserialize(new BinaryMap(), source);
    }

    @Override
    public BinaryMap deserialize(BinaryMap reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, bytes.length);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        target.write(bytes);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BinaryMapSerializer;
    }
}

