/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.util.Preconditions;

public class BinaryRowSerializer
extends AbstractRowSerializer<BinaryRow> {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH_SIZE_IN_BYTES = 4;
    private final int fixedLengthPartSize;

    public BinaryRowSerializer() {
        this(new InternalType[0]);
    }

    public BinaryRowSerializer(InternalType ... types) {
        this(TypeConverters.createExternalTypeInfoFromDataTypes(types));
    }

    public BinaryRowSerializer(TypeInformation<?> ... types) {
        super(types);
        this.fixedLengthPartSize = BinaryRow.calculateFixPartSizeInBytes(this.numFields);
    }

    @Override
    public BinaryRow baseRowToBinary(BinaryRow baseRow) throws IOException {
        return baseRow;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<BinaryRow> duplicate() {
        return new BinaryRowSerializer(this.types);
    }

    @Override
    public BinaryRow createInstance() {
        return new BinaryRow(this.numFields);
    }

    @Override
    public BinaryRow copy(BinaryRow from) {
        return this.copy(from, new BinaryRow(this.numFields));
    }

    @Override
    public BinaryRow copy(BinaryRow from, BinaryRow reuse) {
        return from.copy(reuse);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryRow record, DataOutputView target) throws IOException {
        int sizeInBytes = record.getSizeInBytes();
        target.writeInt(sizeInBytes);
        int offset = record.getBaseOffset();
        for (MemorySegment segment : record.getAllSegments()) {
            int remain = segment.size() - offset;
            int copySize = remain > sizeInBytes ? sizeInBytes : remain;
            target.write(segment, offset, copySize);
            sizeInBytes -= copySize;
            offset = 0;
        }
        if (sizeInBytes != 0) {
            throw new RuntimeException("No copy finished, this should be a bug, The remaining length is: " + sizeInBytes);
        }
    }

    @Override
    public BinaryRow deserialize(DataInputView source) throws IOException {
        BinaryRow row2 = new BinaryRow(this.numFields);
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        row2.pointTo(MemorySegmentFactory.wrap(bytes), 0, length);
        return row2;
    }

    @Override
    public BinaryRow deserialize(BinaryRow reuse, DataInputView source) throws IOException {
        MemorySegment segment = reuse.getMemorySegment();
        Preconditions.checkArgument(segment == null || reuse.getAllSegments().length == 1 && reuse.getBaseOffset() == 0);
        int length = source.readInt();
        if (segment == null || segment.size() < length) {
            segment = MemorySegmentFactory.wrap(new byte[length]);
        }
        source.readFully(segment.getHeapMemory(), 0, length);
        reuse.pointTo(segment, 0, length);
        return reuse;
    }

    @Override
    public int serializeToPages(BinaryRow record, AbstractPagedOutputView target) throws IOException {
        Preconditions.checkArgument(target.getHeaderLength() == 0);
        int sizeInBytes = record.getSizeInBytes();
        int skip = this.checkSkipWrite(target);
        if (record.getAllSegments().length == 1) {
            target.writeInt(sizeInBytes);
            target.write(record.getMemorySegment(), record.getBaseOffset(), sizeInBytes);
        } else {
            this.serializeToPagesSlow(record, target);
        }
        return skip;
    }

    private void serializeToPagesSlow(BinaryRow record, AbstractPagedOutputView out) throws IOException {
        out.writeInt(record.getSizeInBytes());
        this.serializeRowToPagesSlow(record, out);
    }

    public void serializeRowToPagesSlow(BinaryRow record, AbstractPagedOutputView out) throws IOException {
        int remainSize = record.getSizeInBytes();
        int posInSegOfRecord = record.getBaseOffset();
        for (MemorySegment segOfRecord : record.getAllSegments()) {
            int nWrite = Math.min(record.getMemorySegment().size() - posInSegOfRecord, remainSize);
            assert (nWrite > 0);
            out.write(segOfRecord, posInSegOfRecord, nWrite);
            posInSegOfRecord = 0;
            if ((remainSize -= nWrite) == 0) break;
        }
        Preconditions.checkArgument(remainSize == 0);
    }

    @Override
    public BinaryRow deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public BinaryRow deserializeFromPages(BinaryRow reuse, AbstractPagedInputView source) throws IOException {
        this.checkSkipRead(source);
        return this.deserialize(reuse, (DataInputView)source);
    }

    @Override
    public BinaryRow mapFromPages(AbstractPagedInputView source) throws IOException {
        BinaryRow row2 = this.createInstance();
        this.pointTo(row2, source);
        return row2;
    }

    @Override
    public BinaryRow mapFromPages(BinaryRow reuse, AbstractPagedInputView source) throws IOException {
        this.pointTo(reuse, source);
        return reuse;
    }

    private void pointTo(BinaryRow row2, AbstractPagedInputView source) throws IOException {
        Preconditions.checkArgument(source.getHeaderLength() == 0);
        this.checkSkipRead(source);
        this.pointTo(source.readInt(), row2, source);
    }

    public void pointTo(int length, BinaryRow row2, AbstractPagedInputView source) throws IOException {
        if (length < 0) {
            throw new IOException(String.format("Read unexpected bytes in source of positionInSegment[%d] and limitInSegment[%d]", source.getCurrentPositionInSegment(), source.getCurrentSegmentLimit()));
        }
        int remainInSegment = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        MemorySegment currSeg = source.getCurrentSegment();
        int currPosInSeg = source.getCurrentPositionInSegment();
        if (remainInSegment >= length) {
            row2.pointTo(currSeg, currPosInSeg, length);
            source.skipBytesToRead(length);
        } else {
            this.pointToSlow(row2, source, length, length - remainInSegment, currSeg, currPosInSeg);
        }
    }

    private void pointToSlow(BinaryRow row2, AbstractPagedInputView source, int sizeInBytes, int remainLength, MemorySegment currSeg, int currPosInSeg) throws IOException {
        int div;
        int segmentSize = currSeg.size();
        int remainder = remainLength - segmentSize * (div = remainLength / segmentSize);
        int varSegSize = remainder == 0 ? div : div + 1;
        MemorySegment[] segments = new MemorySegment[varSegSize + 1];
        segments[0] = currSeg;
        for (int i = 1; i <= varSegSize; ++i) {
            source.advance();
            segments[i] = source.getCurrentSegment();
        }
        int remainLenInLastSeg = remainder == 0 ? segmentSize : remainder;
        source.skipBytesToRead(remainLenInLastSeg);
        row2.pointTo(segments, currPosInSeg, sizeInBytes);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public void copyFromPagesToView(AbstractPagedInputView source, DataOutputView target) throws IOException {
        this.checkSkipRead(source);
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BinaryRowSerializer && Arrays.equals(this.types, ((BinaryRowSerializer)obj).types);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BinaryRowSerializer;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    public int getSerializedRowFixedPartLength() {
        return this.getFixedLengthPartSize() + 4;
    }

    public int getFixedLengthPartSize() {
        return this.fixedLengthPartSize;
    }

    public boolean isRowFixedLength() {
        for (TypeInformation<?> type : this.getTypes()) {
            if (BinaryRow.isFixedLength(TypeConverters.createInternalTypeFromTypeInfo(type))) continue;
            return false;
        }
        return true;
    }

    private int checkSkipWrite(AbstractPagedOutputView out) throws IOException {
        int available = out.getSegmentSize() - out.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            out.advance();
            return available;
        }
        return 0;
    }

    public void checkSkipRead(AbstractPagedInputView source) throws IOException {
        int available = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            source.advance();
        }
    }
}

