/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.typeutils.BinaryStringSerializer;

@Internal
public final class BinaryStringComparator
extends BasicTypeComparator<BinaryString> {
    private static final long serialVersionUID = 1L;

    public BinaryStringComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        BinaryString s1 = BinaryStringSerializer.deserializeInternal(firstSource);
        BinaryString s2 = BinaryStringSerializer.deserializeInternal(secondSource);
        int comp = s1.compareTo(s2);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(BinaryString record, MemorySegment target, int offset, int len) {
        BinaryRowUtil.putBinaryStringNormalizedKey(record, target, offset, len);
    }

    public BinaryStringComparator duplicate() {
        return new BinaryStringComparator(this.ascendingComparison);
    }
}

