/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.Decimal;

@Internal
public final class DecimalSerializer
extends TypeSerializer<Decimal> {
    private static final long serialVersionUID = 1L;
    final int precision;
    final int scale;
    private String serializationFormatIdentifier;

    public static DecimalSerializer of(int precision, int scale) {
        return new DecimalSerializer(precision, scale);
    }

    public DecimalSerializer(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Decimal createInstance() {
        return Decimal.zero(this.precision, this.scale);
    }

    @Override
    public Decimal copy(Decimal from) {
        return from.copy();
    }

    @Override
    public Decimal copy(Decimal from, Decimal reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Decimal record, DataOutputView target) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            assert (record.isCompact());
            target.writeLong(record.toUnscaledLong());
        } else {
            byte[] bytes = record.toUnscaledBytes();
            target.writeInt(bytes.length);
            target.write(bytes);
        }
    }

    @Override
    public Decimal deserialize(DataInputView source) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            long longVal = source.readLong();
            return Decimal.fromUnscaledLong(this.precision, this.scale, longVal);
        }
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return Decimal.fromUnscaledBytes(this.precision, this.scale, bytes);
    }

    @Override
    public Decimal deserialize(Decimal record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        target.write(bytes);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof DecimalSerializer;
    }

    public DecimalSerializer duplicate() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalSerializer)) {
            return false;
        }
        DecimalSerializer that = (DecimalSerializer)obj;
        return this.precision == that.precision && this.scale == that.scale;
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + this.precision + "," + this.scale;
        }
        return id;
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<Decimal> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

