/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedBigDecSerializer
extends TypeSerializer<BigDecimal> {
    private static final long serialVersionUID = 1L;
    public static final OrderedBigDecSerializer ASC_INSTANCE = new OrderedBigDecSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedBigDecSerializer DESC_INSTANCE = new OrderedBigDecSerializer(OrderedBytes.Order.DESCENDING);
    private final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    private OrderedBigDecSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public TypeSerializer<BigDecimal> duplicate() {
        return new OrderedBigDecSerializer(this.ord);
    }

    @Override
    public BigDecimal createInstance() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal copy(BigDecimal from) {
        return from;
    }

    @Override
    public BigDecimal copy(BigDecimal from, BigDecimal reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BigDecimal record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeBigDecimal(target, record, this.ord);
    }

    @Override
    public BigDecimal deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeBigDecimal(source, this.ord);
    }

    @Override
    public BigDecimal deserialize(BigDecimal reuse, DataInputView source) throws IOException {
        return this.orderedBytes.decodeBigDecimal(source, this.ord);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeBigDecimal(target, this.orderedBytes.decodeBigDecimal(source, this.ord), this.ord);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            OrderedBigDecSerializer other = (OrderedBigDecSerializer)obj;
            return this.ord.equals((Object)other.ord);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBigDecSerializer;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<BigDecimal> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + (Object)((Object)this.ord);
        }
        return id;
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

