/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedBinaryStringSerializer
extends TypeSerializer<BinaryString> {
    private static final long serialVersionUID = 1L;
    public static final OrderedBinaryStringSerializer ASC_INSTANCE = new OrderedBinaryStringSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedBinaryStringSerializer DESC_INSTANCE = new OrderedBinaryStringSerializer(OrderedBytes.Order.DESCENDING);
    private final OrderedBytes orderedBytes;
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    private OrderedBinaryStringSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
        this.orderedBytes = new OrderedBytes();
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public TypeSerializer<BinaryString> duplicate() {
        return new OrderedBinaryStringSerializer(this.ord);
    }

    @Override
    public BinaryString createInstance() {
        return BinaryString.EMPTY_UTF8;
    }

    @Override
    public BinaryString copy(BinaryString from) {
        return BinaryString.fromBytes(from.getBytes());
    }

    @Override
    public BinaryString copy(BinaryString from, BinaryString reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryString record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeBinaryString(target, record, this.ord);
    }

    @Override
    public BinaryString deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeBinaryString(source, this.ord);
    }

    @Override
    public BinaryString deserialize(BinaryString record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeBinaryString(target, this.orderedBytes.decodeBinaryString(source, this.ord), this.ord);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            OrderedBinaryStringSerializer other = (OrderedBinaryStringSerializer)obj;
            return this.ord.equals((Object)other.ord);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBinaryStringSerializer;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<BinaryString> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + (Object)((Object)this.ord);
        }
        return id;
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

