/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedShortSerializer
extends TypeSerializerSingleton<Short> {
    private static final long serialVersionUID = 1L;
    public static final OrderedShortSerializer ASC_INSTANCE = new OrderedShortSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedShortSerializer DESC_INSTANCE = new OrderedShortSerializer(OrderedBytes.Order.DESCENDING);
    private static final Short ZERO = 0;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedShortSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Short createInstance() {
        return ZERO;
    }

    @Override
    public Short copy(Short from) {
        return from;
    }

    @Override
    public Short copy(Short from, Short reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(Short record, DataOutputView target) throws IOException {
        orderedBytes.encodeShort(target, record, this.ord);
    }

    @Override
    public Short deserialize(DataInputView source) throws IOException {
        return orderedBytes.decodeShort(source, this.ord);
    }

    @Override
    public Short deserialize(Short reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeShort(target, orderedBytes.decodeShort(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedShortSerializer;
    }
}

