/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.sql.Time;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedSqlTimeSerializer
extends TypeSerializerSingleton<Time> {
    private static final long serialVersionUID = 1L;
    public static final OrderedSqlTimeSerializer ASC_INSTANCE = new OrderedSqlTimeSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedSqlTimeSerializer DESC_INSTANCE = new OrderedSqlTimeSerializer(OrderedBytes.Order.DESCENDING);
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedSqlTimeSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Time createInstance() {
        return new Time(0L);
    }

    @Override
    public Time copy(Time from) {
        if (from == null) {
            return null;
        }
        return new Time(from.getTime());
    }

    @Override
    public Time copy(Time from, Time reuse) {
        if (from == null) {
            return null;
        }
        reuse.setTime(from.getTime());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Time record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        orderedBytes.encodeLong(target, record.getTime(), this.ord);
    }

    @Override
    public Time deserialize(DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        return new Time(v);
    }

    @Override
    public Time deserialize(Time reuse, DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        reuse.setTime(v);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeLong(target, orderedBytes.decodeLong(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedSqlTimeSerializer;
    }
}

