/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.sql.Timestamp;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedSqlTimestampSerializer
extends TypeSerializerSingleton<Timestamp> {
    private static final long serialVersionUID = 1L;
    public static final OrderedSqlTimestampSerializer ASC_INSTANCE = new OrderedSqlTimestampSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedSqlTimestampSerializer DESC_INSTANCE = new OrderedSqlTimestampSerializer(OrderedBytes.Order.DESCENDING);
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedSqlTimestampSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Timestamp createInstance() {
        return new Timestamp(0L);
    }

    @Override
    public Timestamp copy(Timestamp from) {
        return new Timestamp(from.getTime());
    }

    @Override
    public Timestamp copy(Timestamp from, Timestamp reuse) {
        if (from == null) {
            return null;
        }
        reuse.setTime(from.getTime());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Timestamp record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        orderedBytes.encodeLong(target, record.getTime(), this.ord);
    }

    @Override
    public Timestamp deserialize(DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        return new Timestamp(v);
    }

    @Override
    public Timestamp deserialize(Timestamp reuse, DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        reuse.setTime(v);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeLong(target, orderedBytes.decodeLong(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedSqlTimestampSerializer;
    }
}

