/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableConfigOptions;

public class NodeResourceUtil {
    public static final long SIZE_IN_MB = 0x100000L;
    public static final ConfigOption<Integer> SQL_RESOURCE_INFER_OPERATOR_PARALLELISM_MIN = ConfigOptions.key("sql.resource.infer.operator.parallelism.min").defaultValue(1).withDescription("Sets min parallelism for operators.");
    public static final ConfigOption<Integer> SQL_RESOURCE_INFER_OPERATOR_MEMORY_MIN = ConfigOptions.key("sql.resource.infer.operator.memory.min.mb").defaultValue(32).withDescription("Maybe the infer's reserved manager mem is too small, so this setting is lower limit for the infer's manager mem.");
    public static final ConfigOption<Double> SQL_RESOURCE_INFER_MEM_RESERVE_PREFER_DISCOUNT = ConfigOptions.key("sql.resource.infer.mem.reserve-prefer.discount").defaultValue(1.0).withDescription("Sets reserve discount to prefer mem.");
    public static final ConfigOption<Integer> SQL_RESOURCE_PER_REQUEST_MEM = ConfigOptions.key("sql.resource.per-request.mem.mb").defaultValue(32).withDescription("Sets the number of per-requested buffers when the operator allocates much more segments from the floating memory pool.");

    public static double getDefaultCpu(Configuration tableConf) {
        return tableConf.getDouble(TableConfigOptions.SQL_RESOURCE_DEFAULT_CPU);
    }

    public static int getOperatorDefaultParallelism(Configuration tableConf, int envParallelism) {
        int parallelism = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_DEFAULT_PARALLELISM);
        if (parallelism <= 0) {
            parallelism = envParallelism;
        }
        return parallelism;
    }

    public static ResourceSpec getDefaultResourceSpec(Configuration tableConf) {
        ResourceSpec.Builder builder = new ResourceSpec.Builder();
        builder.setCpuCores(NodeResourceUtil.getDefaultCpu(tableConf));
        builder.setHeapMemoryInMB(NodeResourceUtil.getDefaultHeapMem(tableConf));
        builder.setDirectMemoryInMB(NodeResourceUtil.getDefaultDirectMem(tableConf));
        return builder.build();
    }

    public static ResourceSpec getResourceSpec(Configuration tableConf, int heapMemory, int directMemory) {
        ResourceSpec.Builder builder = new ResourceSpec.Builder();
        builder.setCpuCores(NodeResourceUtil.getDefaultCpu(tableConf));
        builder.setHeapMemoryInMB(heapMemory);
        builder.setDirectMemoryInMB(directMemory);
        return builder.build();
    }

    public static int getDefaultHeapMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_DEFAULT_MEM);
    }

    public static int getDefaultDirectMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_DEFAULT_DIRECT_MEM);
    }

    public static int getSortBufferManagedMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SORT_BUFFER_MEM);
    }

    public static int getSortBufferManagedPreferredMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SORT_BUFFER_PREFER_MEM);
    }

    public static int getSortBufferManagedMaxMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SORT_BUFFER_MAX_MEM);
    }

    public static int getExternalBufferManagedMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_EXTERNAL_BUFFER_MEM);
    }

    public static int getHashJoinTableManagedMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_JOIN_TABLE_MEM);
    }

    public static int getSourceMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SOURCE_DEFAULT_MEM);
    }

    public static int getSourceDirectMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SOURCE_DIRECT_MEM);
    }

    public static int getSourceParallelism(Configuration tableConf, int envParallelism) {
        int parallelism = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SOURCE_PARALLELISM);
        if (parallelism <= 0) {
            parallelism = NodeResourceUtil.getOperatorDefaultParallelism(tableConf, envParallelism);
        }
        return parallelism;
    }

    public static int getSinkParallelism(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SINK_PARALLELISM);
    }

    public static int getSinkMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SINK_DEFAULT_MEM);
    }

    public static int getSinkDirectMem(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_SINK_DIRECT_MEM);
    }

    public static int getHashAggManagedMemory(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_AGG_TABLE_MEM);
    }

    public static int getWindowAggBufferLimitSize(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT);
    }

    public static long getRelCountPerPartition(Configuration tableConf) {
        return tableConf.getLong(TableConfigOptions.SQL_RESOURCE_INFER_ROWS_PER_PARTITION);
    }

    public static int getSourceSizePerPartition(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_INFER_SOURCE_MB_PER_PARTITION);
    }

    public static int getSourceMaxParallelism(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_INFER_SOURCE_PARALLELISM_MAX);
    }

    public static int getOperatorMaxParallelism(Configuration tableConf) {
        return tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_INFER_OPERATOR_PARALLELISM_MAX);
    }

    public static int getOperatorMinParallelism(Configuration tableConf) {
        return tableConf.getInteger(SQL_RESOURCE_INFER_OPERATOR_PARALLELISM_MIN);
    }

    public static int calOperatorParallelism(double rowCount, Configuration tableConf) {
        int maxParallelism = NodeResourceUtil.getOperatorMaxParallelism(tableConf);
        int minParallelism = NodeResourceUtil.getOperatorMinParallelism(tableConf);
        int resultParallelism = (int)(rowCount / (double)NodeResourceUtil.getRelCountPerPartition(tableConf));
        return Math.max(Math.min(resultParallelism, maxParallelism), minParallelism);
    }

    public static int getHashJoinTableManagedPreferredMemory(Configuration tableConf) {
        int memory = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_JOIN_TABLE_PREFER_MEM);
        if (memory <= 0) {
            memory = NodeResourceUtil.getHashJoinTableManagedMemory(tableConf);
        }
        return memory;
    }

    public static int getHashJoinTableManagedMaxMemory(Configuration tableConf) {
        int memory = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_JOIN_TABLE_MAX_MEM);
        if (memory <= 0) {
            memory = NodeResourceUtil.getHashJoinTableManagedPreferredMemory(tableConf);
        }
        return memory;
    }

    public static int getHashAggManagedPreferredMemory(Configuration tableConf) {
        int memory = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_AGG_TABLE_PREFER_MEM);
        if (memory <= 0) {
            memory = NodeResourceUtil.getHashAggManagedMemory(tableConf);
        }
        return memory;
    }

    public static int getHashAggManagedMaxMemory(Configuration tableConf) {
        int memory = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_HASH_AGG_TABLE_MAX_MEM);
        if (memory <= 0) {
            memory = NodeResourceUtil.getHashAggManagedPreferredMemory(tableConf);
        }
        return memory;
    }

    public static int getOperatorMinManagedMem(Configuration tableConf) {
        return tableConf.getInteger(SQL_RESOURCE_INFER_OPERATOR_MEMORY_MIN);
    }

    public static Tuple3<Integer, Integer, Integer> reviseAndGetInferManagedMem(Configuration tableConf, int memCostInMB) {
        double reservedDiscount = tableConf.getDouble(SQL_RESOURCE_INFER_MEM_RESERVE_PREFER_DISCOUNT);
        if (reservedDiscount > 1.0 || reservedDiscount <= 0.0) {
            throw new IllegalArgumentException(SQL_RESOURCE_INFER_MEM_RESERVE_PREFER_DISCOUNT + " should be > 0 and <= 1");
        }
        int maxMem = tableConf.getInteger(TableConfigOptions.SQL_RESOURCE_INFER_OPERATOR_MEM_MAX);
        int minMem = NodeResourceUtil.getOperatorMinManagedMem(tableConf);
        int preferMem = Math.max(Math.min(maxMem, memCostInMB), minMem);
        int reservedMem = Math.max((int)((double)preferMem * reservedDiscount), minMem);
        return new Tuple3<Integer, Integer, Integer>(reservedMem, preferMem, maxMem);
    }

    public static int getPerRequestManagedMemory(Configuration tableConf) {
        return tableConf.getInteger(SQL_RESOURCE_PER_REQUEST_MEM);
    }

    public static boolean enableRunningUnitSchedule(Configuration tableConf) {
        return tableConf.getBoolean(TableConfigOptions.SQL_SCHEDULE_RUNNING_UNIT_ENABLED);
    }

    public static InferMode getInferMode(Configuration tableConf) {
        String config = tableConf.getString(TableConfigOptions.SQL_RESOURCE_INFER_MODE);
        try {
            return InferMode.valueOf(config);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Infer mode can only be set: NONE, SOURCE or ALL.");
        }
    }

    public static enum InferMode {
        NONE,
        ONLY_SOURCE,
        ALL;

    }
}

