/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProperties
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(TableProperties.class);
    public static final String TABLE_NAME = "__tablename__".toLowerCase();
    public static final String BLINK_ENVIRONMENT_TYPE_KEY = "blinkEnvironmentTypeKey".toLowerCase();
    public static final String BLINK_ENVIRONMENT_STREAM_VALUE = "stream".toLowerCase();
    public static final String BLINK_ENVIRONMENT_BATCHEXEC_VALUE = "batchExec".toLowerCase();
    public static final String BLINK_CONNECTOR_TYPE_KEY = "type".toLowerCase();
    public static final List<String> INTERNAL_KEYS = Arrays.asList(TABLE_NAME, BLINK_ENVIRONMENT_TYPE_KEY, BLINK_ENVIRONMENT_STREAM_VALUE, BLINK_ENVIRONMENT_BATCHEXEC_VALUE, BLINK_CONNECTOR_TYPE_KEY, SchemaValidator.SCHEMA());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableProperties toKeyLowerCase() {
        TableProperties ret = new TableProperties();
        HashMap hashMap = this.confData;
        synchronized (hashMap) {
            for (Map.Entry entry : this.confData.entrySet()) {
                ret.setString(((String)entry.getKey()).toLowerCase(), entry.getValue().toString());
            }
            return ret;
        }
    }

    public TableProperties putProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.setString(property.getKey(), property.getValue());
        }
        return this;
    }

    public TableProperties property(String key, String value) {
        this.setString(key, value);
        return this;
    }

    public void putSchemaIntoProperties(RichTableSchema schema2) {
        try {
            byte[] serialized = InstantiationUtil.serializeObject(schema2);
            String encoded = Base64.getEncoder().encodeToString(serialized);
            this.setString(SchemaValidator.SCHEMA(), encoded);
        }
        catch (IOException ioe) {
            LOG.error("Exception when put rich table schema to configuration: {}", ioe.getCause());
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public RichTableSchema readSchemaFromProperties(ClassLoader classLoader) {
        try {
            String encoded = this.getString(SchemaValidator.SCHEMA(), null);
            return (RichTableSchema)InstantiationUtil.deserializeObject(Base64.getDecoder().decode(encoded), classLoader);
        }
        catch (IOException | ClassNotFoundException cne) {
            LOG.error("Exception when put rich table schema to configuration: {}", cne.getCause());
            throw new RuntimeException(cne.getMessage());
        }
    }

    public void putTableNameIntoProperties(String tableName) {
        Preconditions.checkArgument(tableName != null);
        this.setString(TABLE_NAME, tableName);
    }

    public String readTableNameFromProperties() {
        return this.getString(TABLE_NAME, null);
    }
}

