/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.hash;

import org.apache.flink.core.memory.MemorySegment;

public final class XXH64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;

    public static long hashInt(int input, long seed) {
        long hash = seed + 2870177450012600261L + 4L;
        hash ^= ((long)input & 0xFFFFFFFFL) * -7046029288634856825L;
        hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
        return XXH64.fmix(hash);
    }

    public static long hashLong(long input, long seed) {
        long hash = seed + 2870177450012600261L + 8L;
        hash ^= Long.rotateLeft(input * -4417276706812531889L, 31) * -7046029288634856825L;
        hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        return XXH64.fmix(hash);
    }

    public static long hashUnsafeBytes(MemorySegment ms, int offset, int length, long seed) {
        int end;
        assert (length >= 0) : "lengthInBytes cannot be negative";
        long hash = XXH64.hashBytesByWords(ms, offset, length, seed);
        if ((long)(offset += length & 0xFFFFFFF8) + 4L <= (long)(end = offset + length)) {
            hash ^= ((long)ms.getInt(offset) & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            offset = (int)((long)offset + 4L);
        }
        while (offset < end) {
            hash ^= ((long)ms.get(offset) & 0xFFL) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            ++offset;
        }
        return XXH64.fmix(hash);
    }

    private static long fmix(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    private static long hashBytesByWords(MemorySegment ms, int offset, int length, long seed) {
        long hash;
        int limit;
        if (length >= 32) {
            limit = length - 32;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += ms.getLong(offset) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += ms.getLong(offset + 8) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += ms.getLong(offset + 16) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += ms.getLong(offset + 24) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((offset = (int)((long)offset + 32L)) <= limit);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += (long)length;
        limit = length - 8;
        while (offset <= limit) {
            long k1 = ms.getLong(offset);
            hash ^= Long.rotateLeft(k1 * -4417276706812531889L, 31) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            offset = (int)((long)offset + 8L);
        }
        return hash;
    }
}

