/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CommonExtendedResource;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.table.util.resource.AbstractJsonSerializable;
import org.apache.flink.table.util.resource.StreamNodeUtil;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamNodeProperty
extends AbstractJsonSerializable
implements Comparable<StreamNodeProperty> {
    private String uid;
    private String name = "";
    private String pact = "";
    private String slotSharingGroup = "default";
    @JsonProperty(value="parallelism")
    private int parallelism;
    @JsonProperty(value="maxParallelism")
    private int maxParallelism;
    @JsonProperty(value="vcore")
    private double cpuCores;
    @JsonProperty(value="heap_memory")
    private int heapMemoryInMB;
    @JsonProperty(value="direct_memory")
    private int directMemoryInMB;
    @JsonProperty(value="native_memory")
    private int nativeMemoryInMB;
    @JsonProperty(value="managed_memory")
    private int managedMemoryInMB;
    @JsonProperty(value="floating_managed_memory")
    private int floatingManagedMemoryInMB;
    @JsonProperty(value="gpu")
    private double gpuLoad;
    @JsonProperty(value="otherResources")
    private Map<String, Double> otherResources;

    public StreamNodeProperty() {
    }

    public StreamNodeProperty(String uid) {
        this.uid = uid;
    }

    public void update(StreamNodeProperty streamNodeProperties) {
        this.uid = streamNodeProperties.getUid();
        this.parallelism = streamNodeProperties.getParallelism();
        this.maxParallelism = streamNodeProperties.getMaxParallelism();
        this.slotSharingGroup = streamNodeProperties.getSlotSharingGroup();
        this.cpuCores = streamNodeProperties.getCpuCores();
        this.heapMemoryInMB = streamNodeProperties.getHeapMemoryInMB();
        this.directMemoryInMB = streamNodeProperties.getDirectMemoryInMB();
        this.nativeMemoryInMB = streamNodeProperties.getNativeMemoryInMB();
        this.managedMemoryInMB = streamNodeProperties.getManagedMemoryInMB();
        this.floatingManagedMemoryInMB = streamNodeProperties.getFloatingManagedMemoryInMB();
        this.gpuLoad = streamNodeProperties.getGpuLoad();
        if (streamNodeProperties.otherResources != null) {
            this.otherResources = new HashMap<String, Double>(streamNodeProperties.otherResources);
        }
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public StreamNodeProperty setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(double cpuCores) {
        this.cpuCores = cpuCores;
    }

    public int getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    public void setHeapMemoryInMB(int heapMemoryInMB) {
        this.heapMemoryInMB = heapMemoryInMB;
    }

    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    public void setDirectMemoryInMB(int directMemoryInMB) {
        this.directMemoryInMB = directMemoryInMB;
    }

    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    public void setNativeMemoryInMB(int nativeMemoryInMB) {
        this.nativeMemoryInMB = nativeMemoryInMB;
    }

    public double getGpuLoad() {
        return this.gpuLoad;
    }

    public void setGpuLoad(double gpuLoad) {
        this.gpuLoad = gpuLoad;
    }

    @Override
    public int compareTo(StreamNodeProperty streamNodeProperty) {
        return this.uid.compareTo(streamNodeProperty.getUid());
    }

    public void apple(StreamNode node) {
        if (node != null) {
            node.setParallelism(Integer.valueOf(this.parallelism));
            StreamNodeUtil.setMaxParallelism(node, this.maxParallelism);
            ResourceSpec.Builder builder = ResourceSpec.newBuilder().setCpuCores(this.cpuCores).setHeapMemoryInMB(this.heapMemoryInMB).setDirectMemoryInMB(this.directMemoryInMB).setNativeMemoryInMB(this.nativeMemoryInMB);
            if (this.gpuLoad > 0.0) {
                builder.setGPUResource(this.gpuLoad);
            }
            if (this.otherResources != null) {
                for (Map.Entry<String, Double> entry : this.otherResources.entrySet()) {
                    builder.addExtendedResource(new CommonExtendedResource(entry.getKey(), entry.getValue()));
                }
            }
            if (this.floatingManagedMemoryInMB > 0) {
                builder.addExtendedResource(new CommonExtendedResource("FLOATING_MANAGED_MEMORY_MB", this.floatingManagedMemoryInMB));
            }
            if (node.getMinResources().getExtendedResources().containsKey("MANAGED_MEMORY_MB")) {
                builder.addExtendedResource(new CommonExtendedResource("MANAGED_MEMORY_MB", node.getMinResources().getExtendedResources().get("MANAGED_MEMORY_MB").getValue()));
            }
            ResourceSpec resourceSpec = builder.build();
            node.setResources(resourceSpec, resourceSpec);
        }
    }

    public int getFloatingManagedMemoryInMB() {
        return this.floatingManagedMemoryInMB;
    }

    public void setFloatingManagedMemoryInMB(int floatingManagedMemoryInMB) {
        this.floatingManagedMemoryInMB = floatingManagedMemoryInMB;
    }

    public int getManagedMemoryInMB() {
        return this.managedMemoryInMB;
    }

    public void setManagedMemoryInMB(int managedMemoryInMB) {
        this.managedMemoryInMB = managedMemoryInMB;
    }

    public String getPact() {
        return this.pact;
    }

    public void setPact(String pact) {
        this.pact = pact;
    }
}

