/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.resource;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamNodeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamNodeUtil.class);

    public static Map<String, StreamNode> setUid(StreamGraph streamGraph) {
        HashMap<String, StreamNode> existedUidMap = new HashMap<String, StreamNode>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        TreeSet<Integer> orderNodeIdSet = new TreeSet<Integer>();
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            orderNodeIdSet.add(streamNode.getId());
        }
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            if (streamNode.getTransformationUID() == null) continue;
            existedUidMap.put(streamNode.getTransformationUID(), streamNode);
        }
        for (Integer nodeId : orderNodeIdSet) {
            StreamNode node = streamGraph.getStreamNode(nodeId);
            String uid = "table-" + atomicInteger.getAndIncrement();
            while (existedUidMap.containsKey(uid)) {
                uid = "table-" + atomicInteger.getAndIncrement();
            }
            StreamNodeUtil.setNodeUID(node, uid);
        }
        return existedUidMap;
    }

    public static void clearAppendUids(StreamGraph graph, Map<String, StreamNode> existedUidMap) {
        for (StreamNode node : graph.getStreamNodes()) {
            if (existedUidMap.containsKey(node.getTransformationUID())) continue;
            StreamNodeUtil.setNodeUID(node, null);
        }
    }

    public static void setNodeUID(StreamNode streamNode, String uid) {
        try {
            Method method = StreamNode.class.getDeclaredMethod("setTransformationUID", String.class);
            method.setAccessible(true);
            method.invoke((Object)streamNode, uid);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            LOG.warn("setNodeUID :" + uid + " failed", (Throwable)e2);
        }
    }

    public static void setMaxParallelism(StreamNode streamNode, int paral) {
        try {
            Method method = StreamNode.class.getDeclaredMethod("setMaxParallelism", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)streamNode, paral);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            LOG.warn("setMaxParallelism paral :" + paral + " failed", (Throwable)e2);
        }
    }

    public static int getMaxParallelism(StreamNode streamNode) {
        try {
            Method method = StreamNode.class.getDeclaredMethod("getMaxParallelism", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)streamNode, new Object[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            LOG.warn("getMaxParallelism failed", (Throwable)e2);
            return -1;
        }
    }
}

