/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.math.BigDecimal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class BigDecParser
extends FieldParser<BigDecimal> {
    private static final BigDecimal BIG_DECIMAL_INSTANCE = BigDecimal.ZERO;
    private BigDecimal result;
    private char[] reuse = null;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, BigDecimal reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        try {
            int length = endPos - startPos;
            if (this.reuse == null || this.reuse.length < length) {
                this.reuse = new char[length];
            }
            for (int j2 = 0; j2 < length; ++j2) {
                byte b = bytes[startPos + j2];
                if ((b < 48 || b > 57) && b != 45 && b != 43 && b != 46 && b != 69 && b != 101) {
                    this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                    return -1;
                }
                this.reuse[j2] = (char)bytes[startPos + j2];
            }
            this.result = new BigDecimal(this.reuse, 0, length);
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (NumberFormatException e2) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public BigDecimal createValue() {
        return BIG_DECIMAL_INSTANCE;
    }

    @Override
    public BigDecimal getLastResult() {
        return this.result;
    }

    public static final BigDecimal parseField(byte[] bytes, int startPos, int length) {
        return BigDecParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final BigDecimal parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int i;
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        byte delByte = (byte)delimiter;
        for (i = 0; i < length && bytes[startPos + i] != delByte; ++i) {
        }
        if (i > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + i - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        char[] chars = new char[i];
        for (int j2 = 0; j2 < i; ++j2) {
            byte b = bytes[startPos + j2];
            if ((b < 48 || b > 57) && b != 45 && b != 43 && b != 46 && b != 69 && b != 101) {
                throw new NumberFormatException();
            }
            chars[j2] = (char)bytes[startPos + j2];
        }
        return new BigDecimal(chars);
    }
}

