/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class DoubleValueParser
extends FieldParser<DoubleValue> {
    private DoubleValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, DoubleValue reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        if (endPos > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[endPos - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, endPos - startPos, ConfigConstants.DEFAULT_CHARSET);
        try {
            double value = Double.parseDouble(str);
            reusable.setValue(value);
            this.result = reusable;
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (NumberFormatException e2) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public DoubleValue createValue() {
        return new DoubleValue();
    }

    @Override
    public DoubleValue getLastResult() {
        return this.result;
    }
}

