/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.TimeConvertUtils;

@PublicEvolving
public class SqlTimestampParser
extends FieldParser<Timestamp> {
    private static final Timestamp TIMESTAMP_INSTANCE = new Timestamp(0L);
    private Timestamp result;
    private TimeZone timezone = null;

    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Timestamp reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        if (endPos > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[endPos - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, endPos - startPos, ConfigConstants.DEFAULT_CHARSET);
        try {
            long val = TimeConvertUtils.timestampStringToUnixDate(str);
            long offset = this.timezone == null ? 0L : (long)this.timezone.getOffset(val);
            this.result = new Timestamp(val - offset);
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (IllegalArgumentException e2) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Timestamp createValue() {
        return TIMESTAMP_INSTANCE;
    }

    @Override
    public Timestamp getLastResult() {
        return this.result;
    }

    public static final Timestamp parseField(byte[] bytes, int startPos, int length) {
        return SqlTimestampParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final Timestamp parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int limitedLen = SqlTimestampParser.nextStringLength(bytes, startPos, length, delimiter);
        if (limitedLen > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + limitedLen - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, limitedLen, ConfigConstants.DEFAULT_CHARSET);
        return new Timestamp(TimeConvertUtils.timestampStringToUnixDate(str));
    }
}

