/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

public final class MathUtils {
    public static int log2floor(int value) throws ArithmeticException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int log2strict(int value) throws ArithmeticException, IllegalArgumentException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException("The given value " + value + " is not a power of two.");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int roundDownToPowerOf2(int value) {
        return Integer.highestOneBit(value);
    }

    public static int checkedDownCast(long value) {
        int downCast = (int)value;
        if ((long)downCast != value) {
            throw new IllegalArgumentException("Cannot downcast long value " + value + " to integer.");
        }
        return downCast;
    }

    public static boolean isPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    public static int jenkinsHash(int code) {
        code = code + 2127912214 + (code << 12);
        code = code ^ 0xC761C23C ^ code >>> 19;
        code = code + 374761393 + (code << 5);
        code = code + -744332180 ^ code << 9;
        code = code + -42973499 + (code << 3);
        return (code = code ^ 0xB55A4F09 ^ code >>> 16) >= 0 ? code : -(code + 1);
    }

    public static int murmurHash(int code) {
        code *= -862048943;
        code = Integer.rotateLeft(code, 15);
        code *= 461845907;
        code = Integer.rotateLeft(code, 13);
        code = code * 5 + -430675100;
        code ^= 4;
        if ((code = MathUtils.bitMix(code)) >= 0) {
            return code;
        }
        if (code != Integer.MIN_VALUE) {
            return -code;
        }
        return 0;
    }

    public static int roundUpToPowerOfTwo(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static int longToIntWithBitMixing(long in) {
        in = (in ^ in >>> 30) * -4658895280553007687L;
        in = (in ^ in >>> 27) * -7723592293110705685L;
        in ^= in >>> 31;
        return (int)in;
    }

    public static int bitMix(int in) {
        in ^= in >>> 16;
        in *= -2048144789;
        in ^= in >>> 13;
        in *= -1028477387;
        in ^= in >>> 16;
        return in;
    }

    private MathUtils() {
    }
}

