/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class TimeConvertUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    public static final int EPOCH_JULIAN = 2440588;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;

    public static int toInt(Date v) {
        return TimeConvertUtils.toInt(v, UTC_TZ);
    }

    public static int toInt(Date v, TimeZone timeZone) {
        return (int)(TimeConvertUtils.toLong(v, timeZone) / 86400000L);
    }

    public static int toInt(Time v) {
        return (int)(TimeConvertUtils.toLong(v) % 86400000L);
    }

    public static long toLong(Date v) {
        return TimeConvertUtils.toLong(v, UTC_TZ);
    }

    public static long toLong(Date v, TimeZone timeZone) {
        long time = v.getTime();
        return time + (long)timeZone.getOffset(time);
    }

    public static long toLong(Timestamp v) {
        return TimeConvertUtils.toLong(v, UTC_TZ);
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? TimeConvertUtils.toLong(o) : (o instanceof String ? TimeConvertUtils.toLong(o) : (Long)TimeConvertUtils.cannotConvert(o, Long.TYPE)));
    }

    private static Object cannotConvert(Object o, Class toType) {
        throw new RuntimeException("Cannot convert " + o + " to " + toType);
    }

    public static Timestamp internalToTimestamp(long v) {
        return new Timestamp(v - (long)UTC_TZ.getOffset(v));
    }

    public static Timestamp internalToTimestamp(Long v) {
        return v == null ? null : TimeConvertUtils.internalToTimestamp((long)v);
    }

    public static java.sql.Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new java.sql.Date(t - (long)UTC_TZ.getOffset(t));
    }

    public static java.sql.Date internalToDate(Integer v) {
        return v == null ? null : TimeConvertUtils.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - UTC_TZ.getOffset(v));
    }

    public static Time internalToTime(Integer v) {
        return v == null ? null : TimeConvertUtils.internalToTime((int)v);
    }

    public static int dateStringToUnixDate(String s) {
        int d;
        int m;
        int y;
        int hyphen1 = s.indexOf(45);
        if (hyphen1 < 0) {
            y = Integer.parseInt(s.trim());
            m = 1;
            d = 1;
        } else {
            y = Integer.parseInt(s.substring(0, hyphen1).trim());
            int hyphen2 = s.indexOf(45, hyphen1 + 1);
            if (hyphen2 < 0) {
                m = Integer.parseInt(s.substring(hyphen1 + 1).trim());
                d = 1;
            } else {
                m = Integer.parseInt(s.substring(hyphen1 + 1, hyphen2).trim());
                d = Integer.parseInt(s.substring(hyphen2 + 1).trim());
            }
        }
        return TimeConvertUtils.ymdToUnixDate(y, m, d);
    }

    public static int timeStringToUnixDate(String v) {
        return TimeConvertUtils.timeStringToUnixDate(v, 0);
    }

    public static int timeStringToUnixDate(String v, int start) {
        int milli;
        int second;
        int minute;
        int hour;
        int colon1 = v.indexOf(58, start);
        if (colon1 < 0) {
            hour = Integer.parseInt(v.trim());
            minute = 1;
            second = 1;
            milli = 0;
        } else {
            hour = Integer.parseInt(v.substring(start, colon1).trim());
            int colon2 = v.indexOf(58, colon1 + 1);
            if (colon2 < 0) {
                minute = Integer.parseInt(v.substring(colon1 + 1).trim());
                second = 1;
                milli = 0;
            } else {
                minute = Integer.parseInt(v.substring(colon1 + 1, colon2).trim());
                int dot = v.indexOf(46, colon2);
                if (dot < 0) {
                    second = Integer.parseInt(v.substring(colon2 + 1).trim());
                    milli = 0;
                } else {
                    second = Integer.parseInt(v.substring(colon2 + 1, dot).trim());
                    milli = TimeConvertUtils.parseFraction(v.substring(dot + 1).trim(), 100);
                }
            }
        }
        return hour * 3600000 + minute * 60000 + second * 1000 + milli;
    }

    private static int parseFraction(String v, int multiplier) {
        int r = 0;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            int x = c < '0' || c > '9' ? 0 : c - 48;
            r += multiplier * x;
            if (multiplier < 10) {
                if (i + 1 >= v.length() || v.charAt(i + 1) < '5') break;
                ++r;
                break;
            }
            multiplier /= 10;
        }
        return r;
    }

    public static long timestampStringToUnixDate(String s) {
        long t;
        long d;
        int space = (s = s.trim()).indexOf(32);
        if (space >= 0) {
            d = TimeConvertUtils.dateStringToUnixDate(s.substring(0, space));
            t = TimeConvertUtils.timeStringToUnixDate(s, space + 1);
        } else {
            int hyphen = s.indexOf(45);
            if (hyphen >= 0) {
                d = TimeConvertUtils.dateStringToUnixDate(s);
                t = 0L;
            } else {
                d = 0L;
                t = Integer.parseInt(s) * 1000;
            }
        }
        return d * 86400000L + t;
    }

    public static String unixTimestampToString(long timestamp) {
        return TimeConvertUtils.unixTimestampToString(timestamp, 0);
    }

    public static String unixTimestampToString(long timestamp, int precision) {
        StringBuilder buf = new StringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        TimeConvertUtils.unixDateToString(buf, date);
        buf.append(' ');
        TimeConvertUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    public static String unixTimeToString(int time) {
        return TimeConvertUtils.unixTimeToString(time, 0);
    }

    public static String unixTimeToString(int time, int precision) {
        StringBuilder buf = new StringBuilder(8);
        TimeConvertUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time, int precision) {
        while (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        TimeConvertUtils.int2(buf, h);
        buf.append(':');
        TimeConvertUtils.int2(buf, m);
        buf.append(':');
        TimeConvertUtils.int2(buf, s);
        if (precision > 0) {
            buf.append('.');
            while (precision > 0) {
                buf.append((char)(48 + ms / 100));
                ms %= 100;
                if ((ms *= 10) == 0) break;
                --precision;
            }
        }
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static String unixDateToString(int date) {
        StringBuilder buf = new StringBuilder(10);
        TimeConvertUtils.unixDateToString(buf, date);
        return buf.toString();
    }

    private static void unixDateToString(StringBuilder buf, int date) {
        TimeConvertUtils.julianToString(buf, date + 2440588);
    }

    private static void julianToString(StringBuilder buf, int julian) {
        int c;
        int b;
        if (julian > 2299160) {
            int a = julian + 32044;
            b = (4 * a + 3) / 146097;
            c = a - b * 146097 / 4;
        } else {
            b = 0;
            c = julian + 32082;
        }
        int d = (4 * c + 3) / 1461;
        int e2 = c - 1461 * d / 4;
        int m = (5 * e2 + 2) / 153;
        int day = e2 - (153 * m + 2) / 5 + 1;
        int month = m + 3 - 12 * (m / 10);
        int year = b * 100 + d - 4800 + m / 10;
        TimeConvertUtils.int4(buf, year);
        buf.append('-');
        TimeConvertUtils.int2(buf, month);
        buf.append('-');
        TimeConvertUtils.int2(buf, day);
    }

    public static int ymdToUnixDate(int year, int month, int day) {
        int julian = TimeConvertUtils.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    public static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int m = month + 12 * a - 3;
        int y = year + 4800 - a;
        int j2 = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
        if (j2 < 2299161) {
            j2 = day + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
        }
        return j2;
    }

    public static String unixDateTimeToString(Object o) {
        if (o instanceof java.sql.Date) {
            return TimeConvertUtils.unixDateToString(TimeConvertUtils.toInt((java.sql.Date)o));
        }
        if (o instanceof Time) {
            return TimeConvertUtils.unixTimeToString(TimeConvertUtils.toInt((Time)o));
        }
        if (o instanceof Timestamp) {
            return TimeConvertUtils.unixTimestampToString(TimeConvertUtils.toLong((Timestamp)o), 3);
        }
        return o.toString();
    }

    public static String unixDateTimeToString(Object o, TimeZone tz) {
        int offset = tz.getOffset(15L);
        if (o instanceof java.sql.Date) {
            return TimeConvertUtils.unixDateToString(TimeConvertUtils.toInt((java.sql.Date)o) + offset);
        }
        if (o instanceof Time) {
            return TimeConvertUtils.unixTimeToString((TimeConvertUtils.toInt((Time)o) + offset) % 86400000);
        }
        if (o instanceof Timestamp) {
            return TimeConvertUtils.unixTimestampToString(TimeConvertUtils.toLong((Timestamp)o) + (long)offset, 3);
        }
        return o.toString();
    }
}

