/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.shaded.calcite.com.google.common.base.Supplier;
import org.apache.flink.shaded.calcite.com.google.common.collect.Multimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Multimaps;
import org.apache.flink.shaded.calcite.com.google.common.collect.SetMultimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;
import org.apache.flink.shaded.calcite.com.google.common.io.Files;
import org.apache.flink.shaded.calcite.com.google.gson.Gson;
import org.apache.flink.shaded.calcite.com.google.gson.GsonBuilder;
import org.apache.flink.shaded.calcite.com.google.gson.JsonArray;
import org.apache.flink.shaded.calcite.com.google.gson.JsonDeserializationContext;
import org.apache.flink.shaded.calcite.com.google.gson.JsonDeserializer;
import org.apache.flink.shaded.calcite.com.google.gson.JsonElement;
import org.apache.flink.shaded.calcite.com.google.gson.JsonObject;
import org.apache.flink.shaded.calcite.com.google.gson.JsonParseException;
import org.apache.flink.shaded.calcite.com.google.gson.JsonSerializationContext;
import org.reflections.Reflections;
import org.reflections.serializers.Serializer;
import org.reflections.util.Utils;

public class JsonSerializer
implements Serializer {
    private Gson gson;

    public Reflections read(InputStream inputStream) {
        return (Reflections)this.getGson().fromJson((Reader)new InputStreamReader(inputStream), Reflections.class);
    }

    public File save(Reflections reflections, String filename) {
        try {
            File file = Utils.prepareFile(filename);
            Files.write(this.toString(reflections), file, Charset.defaultCharset());
            return file;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public String toString(Reflections reflections) {
        return this.getGson().toJson((Object)reflections);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Multimap.class, (Object)new org.apache.flink.shaded.calcite.com.google.gson.JsonSerializer<Multimap>(){

                public JsonElement serialize(Multimap multimap, Type type, JsonSerializationContext jsonSerializationContext) {
                    return jsonSerializationContext.serialize(multimap.asMap());
                }
            }).registerTypeAdapter(Multimap.class, (Object)new JsonDeserializer<Multimap>(){

                public Multimap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    SetMultimap map2 = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                        @Override
                        public Set<String> get() {
                            return Sets.newHashSet();
                        }
                    });
                    for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            map2.get(entry.getKey()).add(element.getAsString());
                        }
                    }
                    return map2;
                }
            }).setPrettyPrinting().create();
        }
        return this.gson;
    }
}

