/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.List;

@CommandMapping(name="setRules", desc="modify the rules, accept param: type={ruleType}&data={ruleJson}")
public class ModifyRulesCommandHandler
implements CommandHandler<String> {
    private static final String WRITE_DS_FAILURE_MSG = "partial success (write data source failed)";
    private static final String FLOW_RULE_TYPE = "flow";
    private static final String DEGRADE_RULE_TYPE = "degrade";
    private static final String SYSTEM_RULE_TYPE = "system";
    private static final String AUTHORITY_RULE_TYPE = "authority";

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String type = request.getParam("type");
        String data = request.getParam("data");
        if (StringUtil.isNotEmpty((String)data)) {
            try {
                data = URLDecoder.decode(data, "utf-8");
            }
            catch (Exception e) {
                RecordLog.info((String)"Decode rule data error", (Throwable)e);
                return CommandResponse.ofFailure(e, "decode rule data error");
            }
        }
        RecordLog.info((String)String.format("Receiving rule change (type: %s): %s", type, data), (Object[])new Object[0]);
        String result = "success";
        if (FLOW_RULE_TYPE.equalsIgnoreCase(type)) {
            List flowRules = JSONArray.parseArray((String)data, FlowRule.class);
            FlowRuleManager.loadRules((List)flowRules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getFlowDataSource(), flowRules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess(result);
        }
        if (AUTHORITY_RULE_TYPE.equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, AuthorityRule.class);
            AuthorityRuleManager.loadRules((List)rules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getAuthorityDataSource(), rules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess(result);
        }
        if (DEGRADE_RULE_TYPE.equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, DegradeRule.class);
            DegradeRuleManager.loadRules((List)rules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getDegradeDataSource(), rules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess(result);
        }
        if (SYSTEM_RULE_TYPE.equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, SystemRule.class);
            SystemRuleManager.loadRules((List)rules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getSystemSource(), rules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess(result);
        }
        return CommandResponse.ofFailure(new IllegalArgumentException("invalid type"));
    }

    private <T> boolean writeToDataSource(WritableDataSource<T> dataSource, T value) {
        if (dataSource != null) {
            try {
                dataSource.write(value);
            }
            catch (Exception e) {
                RecordLog.warn((String)"Write data source failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

