/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat.client;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.endpoint.Endpoint;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponseParser;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SocketFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;

public class SimpleHttpClient {
    public SimpleHttpResponse get(SimpleHttpRequest request) throws IOException {
        if (request == null) {
            return null;
        }
        return this.request(request.getEndpoint(), RequestMethod.GET, request.getRequestPath(), request.getParams(), request.getCharset(), request.getSoTimeout());
    }

    public SimpleHttpResponse post(SimpleHttpRequest request) throws IOException {
        if (request == null) {
            return null;
        }
        return this.request(request.getEndpoint(), RequestMethod.POST, request.getRequestPath(), request.getParams(), request.getCharset(), request.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleHttpResponse request(Endpoint endpoint, RequestMethod type, String requestPath, Map<String, String> paramsMap, Charset charset, int soTimeout) throws IOException {
        SimpleHttpResponse simpleHttpResponse;
        block11: {
            Socket socket = null;
            InetSocketAddress socketAddress = new InetSocketAddress(endpoint.getHost(), endpoint.getPort());
            try {
                socket = SocketFactory.getSocket(endpoint.getProtocol());
                socket.setSoTimeout(soTimeout);
                socket.connect(socketAddress, soTimeout);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), charset));
                requestPath = this.getRequestPath(type, requestPath, paramsMap, charset);
                writer.write(this.getStatusLine(type, requestPath) + "\r\n");
                if (charset != null) {
                    writer.write("Content-Type: application/x-www-form-urlencoded; charset=" + charset.name() + "\r\n");
                } else {
                    writer.write("Content-Type: application/x-www-form-urlencoded\r\n");
                }
                writer.write("Host: " + socketAddress.getHostName() + "\r\n");
                if (type == RequestMethod.GET) {
                    writer.write("Content-Length: 0\r\n");
                    writer.write("\r\n");
                } else {
                    String params = this.encodeRequestParams(paramsMap, charset);
                    writer.write("Content-Length: " + params.getBytes(charset).length + "\r\n");
                    writer.write("\r\n");
                    writer.write(params);
                }
                writer.flush();
                SimpleHttpResponse response = new SimpleHttpResponseParser().parse(socket.getInputStream());
                socket.close();
                socket = null;
                simpleHttpResponse = response;
                if (socket == null) break block11;
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception ex) {
                        RecordLog.warn((String)"Error when closing {} request to {} in SimpleHttpClient", (Object[])new Object[]{type, socketAddress, ex});
                    }
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (Exception ex) {
                RecordLog.warn((String)"Error when closing {} request to {} in SimpleHttpClient", (Object[])new Object[]{type, socketAddress, ex});
            }
        }
        return simpleHttpResponse;
    }

    private String getRequestPath(RequestMethod type, String requestPath, Map<String, String> paramsMap, Charset charset) {
        if (type == RequestMethod.GET) {
            if (requestPath.contains("?")) {
                return requestPath + "&" + this.encodeRequestParams(paramsMap, charset);
            }
            return requestPath + "?" + this.encodeRequestParams(paramsMap, charset);
        }
        return requestPath;
    }

    private String getStatusLine(RequestMethod type, String requestPath) {
        if (type == RequestMethod.POST) {
            return "POST " + requestPath + " HTTP/1.1";
        }
        return "GET " + requestPath + " HTTP/1.1";
    }

    private String encodeRequestParams(Map<String, String> paramsMap, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is not allowed to be null");
        }
        if (paramsMap == null || paramsMap.isEmpty()) {
            return "";
        }
        try {
            StringBuilder paramsBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                paramsBuilder.append(URLEncoder.encode(entry.getKey(), charset.name())).append("=").append(URLEncoder.encode(entry.getValue(), charset.name())).append("&");
            }
            if (paramsBuilder.length() > 0) {
                paramsBuilder.delete(paramsBuilder.length() - 1, paramsBuilder.length());
            }
            return paramsBuilder.toString();
        }
        catch (Throwable e) {
            RecordLog.warn((String)"Encode request params fail", (Throwable)e);
            return "";
        }
    }

    private static enum RequestMethod {
        GET,
        POST;

    }
}

