/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.imagesynthesis;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.GsonExclude;
import com.alibaba.dashscope.utils.JsonUtils;
import com.alibaba.dashscope.utils.PreprocessInputImage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ImageSynthesisParam
extends HalfDuplexServiceParam {
    private Integer n;
    private String size;
    private Integer steps;
    private Integer scale;
    private Integer seed;
    private String style;
    @NonNull
    private String prompt;
    private String negativePrompt;
    private String refImage;
    private String sketchImageUrl;
    private List<String> images;
    private String function;
    private String baseImageUrl;
    private String maskImageUrl;
    @GsonExclude
    protected Map<String, Object> extraInputs;
    private Boolean promptExtend;
    private Boolean watermark;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("prompt", this.prompt);
        if (this.negativePrompt != null && !this.negativePrompt.isEmpty()) {
            jsonObject.addProperty("negative_prompt", this.negativePrompt);
        }
        if (this.refImage != null && !this.refImage.isEmpty()) {
            jsonObject.addProperty("ref_img", this.refImage);
        }
        if (this.sketchImageUrl != null && !this.sketchImageUrl.isEmpty()) {
            jsonObject.addProperty("sketch_image_url", this.sketchImageUrl);
        }
        if (this.function != null && !this.function.isEmpty()) {
            jsonObject.addProperty("function", this.function);
        }
        if (this.baseImageUrl != null && !this.baseImageUrl.isEmpty()) {
            jsonObject.addProperty("base_image_url", this.baseImageUrl);
        }
        if (this.maskImageUrl != null && !this.maskImageUrl.isEmpty()) {
            jsonObject.addProperty("mask_image_url", this.maskImageUrl);
        }
        if (this.images != null && !this.images.isEmpty()) {
            jsonObject.add("images", (JsonElement)JsonUtils.toJsonArray(this.images));
        }
        if (this.extraInputs != null && !this.extraInputs.isEmpty()) {
            JsonObject extraInputsJsonObject = JsonUtils.parametersToJsonObject(this.extraInputs);
            jsonObject = JsonUtils.merge(jsonObject, extraInputsJsonObject);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.n != null) {
            params.put("n", this.n);
        }
        if (this.size != null) {
            params.put("size", this.size);
        }
        if (this.negativePrompt != null) {
            params.put("negative_prompt", this.negativePrompt);
        }
        if (this.steps != null) {
            params.put("steps", this.steps);
        }
        if (this.scale != null) {
            params.put("scale", this.scale);
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        if (this.style != null) {
            params.put("style", this.style);
        }
        if (this.promptExtend != null) {
            params.put("prompt_extend", this.promptExtend);
        }
        if (this.watermark != null) {
            params.put("watermark", this.watermark);
        }
        params.putAll(super.getParameters());
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        body.add("input", (JsonElement)this.getInput());
        if (this.getParameters() != null) {
            body.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return body;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    public void checkAndUpload() throws NoApiKeyException, UploadFileException {
        boolean isUpload;
        HashMap<String, String> inputChecks = new HashMap<String, String>();
        inputChecks.put("ref_img", this.refImage);
        inputChecks.put("sketch_image_url", this.sketchImageUrl);
        inputChecks.put("base_image_url", this.baseImageUrl);
        inputChecks.put("mask_image_url", this.maskImageUrl);
        int imagesSize = 0;
        if (this.images != null) {
            imagesSize = this.images.size();
            for (int i = 0; i < imagesSize; ++i) {
                inputChecks.put("images[" + i + "]", this.images.get(i));
            }
        }
        if (isUpload = PreprocessInputImage.checkAndUploadImage(this.getModel(), inputChecks, this.getApiKey())) {
            this.putHeader("X-DashScope-OssResourceResolve", "enable");
            this.refImage = (String)inputChecks.get("ref_img");
            this.sketchImageUrl = (String)inputChecks.get("sketch_image_url");
            this.baseImageUrl = (String)inputChecks.get("base_image_url");
            this.maskImageUrl = (String)inputChecks.get("mask_image_url");
            if (imagesSize > 0) {
                ArrayList<String> newImages = new ArrayList<String>();
                for (int i = 0; i < imagesSize; ++i) {
                    newImages.add((String)inputChecks.get("images[" + i + "]"));
                }
                this.images = newImages;
            }
        }
    }

    private static Integer $default$n() {
        return null;
    }

    private static String $default$size() {
        return null;
    }

    private static Integer $default$steps() {
        return null;
    }

    private static Integer $default$scale() {
        return null;
    }

    private static Integer $default$seed() {
        return null;
    }

    private static String $default$style() {
        return null;
    }

    private static String $default$function() {
        return null;
    }

    private static String $default$baseImageUrl() {
        return null;
    }

    private static String $default$maskImageUrl() {
        return null;
    }

    private static Boolean $default$promptExtend() {
        return null;
    }

    private static Boolean $default$watermark() {
        return null;
    }

    protected ImageSynthesisParam(ImageSynthesisParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        Map<Object, Object> extraInputs;
        this.n = ((ImageSynthesisParamBuilder)b).n$set ? ((ImageSynthesisParamBuilder)b).n$value : ImageSynthesisParam.$default$n();
        this.size = ((ImageSynthesisParamBuilder)b).size$set ? ((ImageSynthesisParamBuilder)b).size$value : ImageSynthesisParam.$default$size();
        this.steps = ((ImageSynthesisParamBuilder)b).steps$set ? ((ImageSynthesisParamBuilder)b).steps$value : ImageSynthesisParam.$default$steps();
        this.scale = ((ImageSynthesisParamBuilder)b).scale$set ? ((ImageSynthesisParamBuilder)b).scale$value : ImageSynthesisParam.$default$scale();
        this.seed = ((ImageSynthesisParamBuilder)b).seed$set ? ((ImageSynthesisParamBuilder)b).seed$value : ImageSynthesisParam.$default$seed();
        this.style = ((ImageSynthesisParamBuilder)b).style$set ? ((ImageSynthesisParamBuilder)b).style$value : ImageSynthesisParam.$default$style();
        this.prompt = ((ImageSynthesisParamBuilder)b).prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.negativePrompt = ((ImageSynthesisParamBuilder)b).negativePrompt;
        this.refImage = ((ImageSynthesisParamBuilder)b).refImage;
        this.sketchImageUrl = ((ImageSynthesisParamBuilder)b).sketchImageUrl;
        this.images = ((ImageSynthesisParamBuilder)b).images;
        this.function = ((ImageSynthesisParamBuilder)b).function$set ? ((ImageSynthesisParamBuilder)b).function$value : ImageSynthesisParam.$default$function();
        this.baseImageUrl = ((ImageSynthesisParamBuilder)b).baseImageUrl$set ? ((ImageSynthesisParamBuilder)b).baseImageUrl$value : ImageSynthesisParam.$default$baseImageUrl();
        this.maskImageUrl = ((ImageSynthesisParamBuilder)b).maskImageUrl$set ? ((ImageSynthesisParamBuilder)b).maskImageUrl$value : ImageSynthesisParam.$default$maskImageUrl();
        switch (((ImageSynthesisParamBuilder)b).extraInputs$key == null ? 0 : ((ImageSynthesisParamBuilder)b).extraInputs$key.size()) {
            case 0: {
                extraInputs = Collections.emptyMap();
                break;
            }
            case 1: {
                extraInputs = Collections.singletonMap(((ImageSynthesisParamBuilder)b).extraInputs$key.get(0), ((ImageSynthesisParamBuilder)b).extraInputs$value.get(0));
                break;
            }
            default: {
                extraInputs = new LinkedHashMap(((ImageSynthesisParamBuilder)b).extraInputs$key.size() < 0x40000000 ? 1 + ((ImageSynthesisParamBuilder)b).extraInputs$key.size() + (((ImageSynthesisParamBuilder)b).extraInputs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < ((ImageSynthesisParamBuilder)b).extraInputs$key.size(); ++$i) {
                    extraInputs.put(((ImageSynthesisParamBuilder)b).extraInputs$key.get($i), ((ImageSynthesisParamBuilder)b).extraInputs$value.get($i));
                }
                extraInputs = Collections.unmodifiableMap(extraInputs);
            }
        }
        this.extraInputs = extraInputs;
        this.promptExtend = ((ImageSynthesisParamBuilder)b).promptExtend$set ? ((ImageSynthesisParamBuilder)b).promptExtend$value : ImageSynthesisParam.$default$promptExtend();
        this.watermark = ((ImageSynthesisParamBuilder)b).watermark$set ? ((ImageSynthesisParamBuilder)b).watermark$value : ImageSynthesisParam.$default$watermark();
    }

    public static ImageSynthesisParamBuilder<?, ?> builder() {
        return new ImageSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSynthesisParam)) {
            return false;
        }
        ImageSynthesisParam other = (ImageSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$steps = this.getSteps();
        Integer other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$promptExtend = this.getPromptExtend();
        Boolean other$promptExtend = other.getPromptExtend();
        if (this$promptExtend == null ? other$promptExtend != null : !((Object)this$promptExtend).equals(other$promptExtend)) {
            return false;
        }
        Boolean this$watermark = this.getWatermark();
        Boolean other$watermark = other.getWatermark();
        if (this$watermark == null ? other$watermark != null : !((Object)this$watermark).equals(other$watermark)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$negativePrompt = this.getNegativePrompt();
        String other$negativePrompt = other.getNegativePrompt();
        if (this$negativePrompt == null ? other$negativePrompt != null : !this$negativePrompt.equals(other$negativePrompt)) {
            return false;
        }
        String this$refImage = this.getRefImage();
        String other$refImage = other.getRefImage();
        if (this$refImage == null ? other$refImage != null : !this$refImage.equals(other$refImage)) {
            return false;
        }
        String this$sketchImageUrl = this.getSketchImageUrl();
        String other$sketchImageUrl = other.getSketchImageUrl();
        if (this$sketchImageUrl == null ? other$sketchImageUrl != null : !this$sketchImageUrl.equals(other$sketchImageUrl)) {
            return false;
        }
        List<String> this$images = this.getImages();
        List<String> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        String this$function = this.getFunction();
        String other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        String this$baseImageUrl = this.getBaseImageUrl();
        String other$baseImageUrl = other.getBaseImageUrl();
        if (this$baseImageUrl == null ? other$baseImageUrl != null : !this$baseImageUrl.equals(other$baseImageUrl)) {
            return false;
        }
        String this$maskImageUrl = this.getMaskImageUrl();
        String other$maskImageUrl = other.getMaskImageUrl();
        if (this$maskImageUrl == null ? other$maskImageUrl != null : !this$maskImageUrl.equals(other$maskImageUrl)) {
            return false;
        }
        Map<String, Object> this$extraInputs = this.getExtraInputs();
        Map<String, Object> other$extraInputs = other.getExtraInputs();
        return !(this$extraInputs == null ? other$extraInputs != null : !((Object)this$extraInputs).equals(other$extraInputs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $promptExtend = this.getPromptExtend();
        result = result * 59 + ($promptExtend == null ? 43 : ((Object)$promptExtend).hashCode());
        Boolean $watermark = this.getWatermark();
        result = result * 59 + ($watermark == null ? 43 : ((Object)$watermark).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $negativePrompt = this.getNegativePrompt();
        result = result * 59 + ($negativePrompt == null ? 43 : $negativePrompt.hashCode());
        String $refImage = this.getRefImage();
        result = result * 59 + ($refImage == null ? 43 : $refImage.hashCode());
        String $sketchImageUrl = this.getSketchImageUrl();
        result = result * 59 + ($sketchImageUrl == null ? 43 : $sketchImageUrl.hashCode());
        List<String> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        String $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        String $baseImageUrl = this.getBaseImageUrl();
        result = result * 59 + ($baseImageUrl == null ? 43 : $baseImageUrl.hashCode());
        String $maskImageUrl = this.getMaskImageUrl();
        result = result * 59 + ($maskImageUrl == null ? 43 : $maskImageUrl.hashCode());
        Map<String, Object> $extraInputs = this.getExtraInputs();
        result = result * 59 + ($extraInputs == null ? 43 : ((Object)$extraInputs).hashCode());
        return result;
    }

    public Integer getN() {
        return this.n;
    }

    public String getSize() {
        return this.size;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public String getStyle() {
        return this.style;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public String getRefImage() {
        return this.refImage;
    }

    public String getSketchImageUrl() {
        return this.sketchImageUrl;
    }

    public List<String> getImages() {
        return this.images;
    }

    public String getFunction() {
        return this.function;
    }

    public String getBaseImageUrl() {
        return this.baseImageUrl;
    }

    public String getMaskImageUrl() {
        return this.maskImageUrl;
    }

    public Map<String, Object> getExtraInputs() {
        return this.extraInputs;
    }

    public Boolean getPromptExtend() {
        return this.promptExtend;
    }

    public Boolean getWatermark() {
        return this.watermark;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setPrompt(@NonNull String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public void setRefImage(String refImage) {
        this.refImage = refImage;
    }

    public void setSketchImageUrl(String sketchImageUrl) {
        this.sketchImageUrl = sketchImageUrl;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setBaseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
    }

    public void setMaskImageUrl(String maskImageUrl) {
        this.maskImageUrl = maskImageUrl;
    }

    public void setExtraInputs(Map<String, Object> extraInputs) {
        this.extraInputs = extraInputs;
    }

    public void setPromptExtend(Boolean promptExtend) {
        this.promptExtend = promptExtend;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    @Override
    public String toString() {
        return "ImageSynthesisParam(n=" + this.getN() + ", size=" + this.getSize() + ", steps=" + this.getSteps() + ", scale=" + this.getScale() + ", seed=" + this.getSeed() + ", style=" + this.getStyle() + ", prompt=" + this.getPrompt() + ", negativePrompt=" + this.getNegativePrompt() + ", refImage=" + this.getRefImage() + ", sketchImageUrl=" + this.getSketchImageUrl() + ", images=" + this.getImages() + ", function=" + this.getFunction() + ", baseImageUrl=" + this.getBaseImageUrl() + ", maskImageUrl=" + this.getMaskImageUrl() + ", extraInputs=" + this.getExtraInputs() + ", promptExtend=" + this.getPromptExtend() + ", watermark=" + this.getWatermark() + ")";
    }

    private static final class ImageSynthesisParamBuilderImpl
    extends ImageSynthesisParamBuilder<ImageSynthesisParam, ImageSynthesisParamBuilderImpl> {
        private ImageSynthesisParamBuilderImpl() {
        }

        @Override
        protected ImageSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public ImageSynthesisParam build() {
            return new ImageSynthesisParam(this);
        }
    }

    public static abstract class ImageSynthesisParamBuilder<C extends ImageSynthesisParam, B extends ImageSynthesisParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private boolean n$set;
        private Integer n$value;
        private boolean size$set;
        private String size$value;
        private boolean steps$set;
        private Integer steps$value;
        private boolean scale$set;
        private Integer scale$value;
        private boolean seed$set;
        private Integer seed$value;
        private boolean style$set;
        private String style$value;
        private String prompt;
        private String negativePrompt;
        private String refImage;
        private String sketchImageUrl;
        private List<String> images;
        private boolean function$set;
        private String function$value;
        private boolean baseImageUrl$set;
        private String baseImageUrl$value;
        private boolean maskImageUrl$set;
        private String maskImageUrl$value;
        private ArrayList<String> extraInputs$key;
        private ArrayList<Object> extraInputs$value;
        private boolean promptExtend$set;
        private Boolean promptExtend$value;
        private boolean watermark$set;
        private Boolean watermark$value;

        public B n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return (B)this.self();
        }

        public B size(String size) {
            this.size$value = size;
            this.size$set = true;
            return (B)this.self();
        }

        public B steps(Integer steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B scale(Integer scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return (B)this.self();
        }

        public B style(String style) {
            this.style$value = style;
            this.style$set = true;
            return (B)this.self();
        }

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        public B negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return (B)this.self();
        }

        public B refImage(String refImage) {
            this.refImage = refImage;
            return (B)this.self();
        }

        public B sketchImageUrl(String sketchImageUrl) {
            this.sketchImageUrl = sketchImageUrl;
            return (B)this.self();
        }

        public B images(List<String> images) {
            this.images = images;
            return (B)this.self();
        }

        public B function(String function) {
            this.function$value = function;
            this.function$set = true;
            return (B)this.self();
        }

        public B baseImageUrl(String baseImageUrl) {
            this.baseImageUrl$value = baseImageUrl;
            this.baseImageUrl$set = true;
            return (B)this.self();
        }

        public B maskImageUrl(String maskImageUrl) {
            this.maskImageUrl$value = maskImageUrl;
            this.maskImageUrl$set = true;
            return (B)this.self();
        }

        public B extraInput(String extraInputKey, Object extraInputValue) {
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            this.extraInputs$key.add(extraInputKey);
            this.extraInputs$value.add(extraInputValue);
            return (B)this.self();
        }

        public B extraInputs(Map<? extends String, ? extends Object> extraInputs) {
            if (extraInputs == null) {
                throw new NullPointerException("extraInputs cannot be null");
            }
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : extraInputs.entrySet()) {
                this.extraInputs$key.add($lombokEntry.getKey());
                this.extraInputs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearExtraInputs() {
            if (this.extraInputs$key != null) {
                this.extraInputs$key.clear();
                this.extraInputs$value.clear();
            }
            return (B)this.self();
        }

        public B promptExtend(Boolean promptExtend) {
            this.promptExtend$value = promptExtend;
            this.promptExtend$set = true;
            return (B)this.self();
        }

        public B watermark(Boolean watermark) {
            this.watermark$value = watermark;
            this.watermark$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageSynthesisParam.ImageSynthesisParamBuilder(super=" + super.toString() + ", n$value=" + this.n$value + ", size$value=" + this.size$value + ", steps$value=" + this.steps$value + ", scale$value=" + this.scale$value + ", seed$value=" + this.seed$value + ", style$value=" + this.style$value + ", prompt=" + this.prompt + ", negativePrompt=" + this.negativePrompt + ", refImage=" + this.refImage + ", sketchImageUrl=" + this.sketchImageUrl + ", images=" + this.images + ", function$value=" + this.function$value + ", baseImageUrl$value=" + this.baseImageUrl$value + ", maskImageUrl$value=" + this.maskImageUrl$value + ", extraInputs$key=" + this.extraInputs$key + ", extraInputs$value=" + this.extraInputs$value + ", promptExtend$value=" + this.promptExtend$value + ", watermark$value=" + this.watermark$value + ")";
        }
    }
}

