/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlEvalVisitorImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleEvalVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SQLEvalVisitorUtils {
    public static Object evalExpr(String dbType, String expr, Object ... parameters) {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr(expr, dbType);
        return SQLEvalVisitorUtils.eval(dbType, (SQLObject)sqlExpr, parameters);
    }

    public static Object evalExpr(String dbType, String expr, List<Object> parameters) {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr(expr);
        return SQLEvalVisitorUtils.eval(dbType, (SQLObject)sqlExpr, parameters);
    }

    public static Object eval(String dbType, SQLObject sqlObject, Object ... parameters) {
        return SQLEvalVisitorUtils.eval(dbType, sqlObject, Arrays.asList(parameters));
    }

    public static Object getValue(SQLObject sqlObject) {
        if (sqlObject instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)sqlObject).getNumber();
        }
        return sqlObject.getAttributes().get("eval.value");
    }

    public static Object eval(String dbType, SQLObject sqlObject, List<Object> parameters) {
        return SQLEvalVisitorUtils.eval(dbType, sqlObject, parameters, true);
    }

    public static Object eval(String dbType, SQLObject sqlObject, List<Object> parameters, boolean throwError) {
        SQLEvalVisitor visitor = SQLEvalVisitorUtils.createEvalVisitor(dbType);
        visitor.setParameters(parameters);
        sqlObject.accept(visitor);
        Object value = SQLEvalVisitorUtils.getValue(sqlObject);
        if (value == null && throwError && !sqlObject.getAttributes().containsKey("eval.value")) {
            throw new DruidRuntimeException("eval error : " + SQLUtils.toSQLString(sqlObject, dbType));
        }
        return value;
    }

    public static SQLEvalVisitor createEvalVisitor(String dbType) {
        if ("mysql".equals(dbType)) {
            return new MySqlEvalVisitorImpl();
        }
        if ("h2".equals(dbType)) {
            return new MySqlEvalVisitorImpl();
        }
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleEvalVisitor();
        }
        if ("postgresql".equals(dbType)) {
            return new PGEvalVisitor();
        }
        return new SQLEvalVisitorImpl();
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        if ("concat".equalsIgnoreCase(x.getMethodName())) {
            StringBuilder buf = new StringBuilder();
            for (SQLExpr item : x.getParameters()) {
                item.accept(visitor);
                Object itemValue = item.getAttributes().get("eval.value");
                if (itemValue == null) continue;
                buf.append(itemValue.toString());
            }
            x.getAttributes().put("eval.value", buf.toString());
        } else if ("now".equalsIgnoreCase(x.getMethodName())) {
            x.getAttributes().put("eval.value", new Date());
        } else if ("ascii".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() == 0) {
                return false;
            }
            SQLExpr param = x.getParameters().get(0);
            param.accept(visitor);
            Object paramValue = param.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            String strValue = paramValue.toString();
            if (strValue.length() == 0) {
                return false;
            }
            char ascii = strValue.charAt(0);
            x.getAttributes().put("eval.value", ascii);
        } else if ("instr".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            String strValue0 = param0Value.toString();
            String strValue1 = param1Value.toString();
            int result = strValue0.indexOf(strValue1) + 1;
            x.putAttribute("eval.value", result);
        } else if ("left".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            int intValue = SQLEvalVisitorUtils._int(param1Value);
            String result = strValue.substring(0, intValue);
            x.putAttribute("eval.value", result);
        } else if ("right".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            int intValue = SQLEvalVisitorUtils._int(param1Value);
            String result = strValue.substring(strValue.length() - intValue, strValue.length());
            x.putAttribute("eval.value", result);
        } else if ("reverse".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            if (param0Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            StringBuilder buf = new StringBuilder();
            for (int i = strValue.length() - 1; i >= 0; --i) {
                buf.append(strValue.charAt(i));
            }
            String result = buf.toString();
            x.putAttribute("eval.value", result);
        } else if ("trim".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            if (param0Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            String result = strValue.trim();
            x.putAttribute("eval.value", result);
        } else if ("length".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            if (param0Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            int result = strValue.length();
            x.putAttribute("eval.value", result);
        } else if ("ucase".equalsIgnoreCase(x.getMethodName()) || "upper".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            if (param0Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            String result = strValue.toUpperCase();
            x.putAttribute("eval.value", result);
        } else if ("lcase".equalsIgnoreCase(x.getMethodName()) || "lower".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            if (param0Value == null) {
                return false;
            }
            String strValue = param0Value.toString();
            String result = strValue.toLowerCase();
            x.putAttribute("eval.value", result);
        } else if ("mod".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            int intValue0 = SQLEvalVisitorUtils._int(param0Value);
            int intValue1 = SQLEvalVisitorUtils._int(param1Value);
            int result = intValue0 % intValue1;
            x.putAttribute("eval.value", result);
        } else if ("abs".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            Number result = paramValue instanceof Integer ? (Number)Math.abs((Integer)paramValue) : (Number)(paramValue instanceof Long ? Long.valueOf(Math.abs((Long)paramValue)) : SQLEvalVisitorUtils._decimal(paramValue).abs());
            x.putAttribute("eval.value", result);
        } else if ("acos".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            double result = Math.acos(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("asin".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            double result = Math.asin(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("atan".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            double result = Math.atan(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("atan2".equalsIgnoreCase(x.getMethodName())) {
            double doubleValue1;
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            double doubleValue0 = SQLEvalVisitorUtils._double(param0Value);
            double result = Math.atan2(doubleValue0, doubleValue1 = SQLEvalVisitorUtils._double(param1Value).doubleValue());
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("ceil".equalsIgnoreCase(x.getMethodName()) || "ceiling".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.ceil(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("cos".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.cos(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("sin".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.sin(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("log".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.log(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("log10".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.log10(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("tan".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.tan(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("sqrt".equalsIgnoreCase(x.getMethodName())) {
            if (x.getParameters().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils._double(paramValue);
            int result = (int)Math.sqrt(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("power".equalsIgnoreCase(x.getMethodName())) {
            double doubleValue1;
            if (x.getParameters().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getParameters().get(0);
            SQLExpr param1 = x.getParameters().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            double doubleValue0 = SQLEvalVisitorUtils._double(param0Value);
            double result = Math.pow(doubleValue0, doubleValue1 = SQLEvalVisitorUtils._double(param1Value).doubleValue());
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("pi".equalsIgnoreCase(x.getMethodName())) {
            x.putAttribute("eval.value", Math.PI);
        } else if ("rand".equalsIgnoreCase(x.getMethodName())) {
            x.putAttribute("eval.value", Math.random());
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLCharExpr x) {
        x.putAttribute("eval.value", x.getText());
        return true;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLBetweenExpr x) {
        x.getTestExpr().accept(visitor);
        if (!x.getTestExpr().getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object value = x.getTestExpr().getAttribute("eval.value");
        x.getBeginExpr().accept(visitor);
        if (!x.getBeginExpr().getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object begin = x.getBeginExpr().getAttribute("eval.value");
        if (SQLEvalVisitorUtils.lt(value, begin)) {
            x.getAttributes().put("eval.value", x.isNot());
            return false;
        }
        x.getEndExpr().accept(visitor);
        if (!x.getEndExpr().getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object end = x.getEndExpr().getAttribute("eval.value");
        if (SQLEvalVisitorUtils.gt(value, end)) {
            x.getAttributes().put("eval.value", x.isNot());
            return false;
        }
        x.getAttributes().put("eval.value", !x.isNot());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLNullExpr x) {
        x.getAttributes().put("eval.value", null);
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLCaseExpr x) {
        Object value;
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(visitor);
            if (!x.getValueExpr().getAttributes().containsKey("eval.value")) {
                return false;
            }
            value = x.getValueExpr().getAttribute("eval.value");
        } else {
            value = null;
        }
        for (SQLCaseExpr.Item item : x.getItems()) {
            item.getConditionExpr().accept(visitor);
            if (!item.getConditionExpr().getAttributes().containsKey("eval.value")) {
                return false;
            }
            Object conditionValue = item.getConditionExpr().getAttribute("eval.value");
            if (!SQLEvalVisitorUtils.eq(value, conditionValue)) continue;
            item.getValueExpr().accept(visitor);
            if (item.getValueExpr().getAttributes().containsKey("eval.value")) {
                x.getAttributes().put("eval.value", item.getValueExpr().getAttribute("eval.value"));
            }
            return false;
        }
        if (x.getElseExpr() != null) {
            x.getElseExpr().accept(visitor);
            if (x.getElseExpr().getAttributes().containsKey("eval.value")) {
                x.getAttributes().put("eval.value", x.getElseExpr().getAttribute("eval.value"));
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLInListExpr x) {
        SQLExpr valueExpr = x.getExpr();
        valueExpr.accept(visitor);
        if (!valueExpr.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object value = valueExpr.getAttribute("eval.value");
        for (SQLExpr item : x.getTargetList()) {
            item.accept(visitor);
            if (!item.getAttributes().containsKey("eval.value")) {
                return false;
            }
            Object itemValue = item.getAttribute("eval.value");
            if (!SQLEvalVisitorUtils.eq(value, itemValue)) continue;
            x.getAttributes().put("eval.value", !x.isNot());
            return false;
        }
        x.getAttributes().put("eval.value", x.isNot());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLQueryExpr x) {
        if (x.getSubQuery().getQuery() instanceof SQLSelectQueryBlock) {
            SQLExpr expr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)x.getSubQuery().getQuery();
            boolean nullFrom = false;
            if (queryBlock.getFrom() == null) {
                nullFrom = true;
            } else if (queryBlock.getFrom() instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)queryBlock.getFrom()).getExpr()) instanceof SQLIdentifierExpr && "dual".equalsIgnoreCase(((SQLIdentifierExpr)expr).getName())) {
                nullFrom = true;
            }
            if (nullFrom) {
                ArrayList<Object> row = new ArrayList<Object>(queryBlock.getSelectList().size());
                for (int i = 0; i < queryBlock.getSelectList().size(); ++i) {
                    SQLSelectItem item = queryBlock.getSelectList().get(i);
                    item.getExpr().accept(visitor);
                    Object cell = item.getExpr().getAttribute("eval.value");
                    row.add(cell);
                }
                ArrayList<ArrayList<Object>> rows = new ArrayList<ArrayList<Object>>(1);
                rows.add(row);
                ArrayList<ArrayList<Object>> result = rows;
                queryBlock.putAttribute("eval.value", result);
                x.getSubQuery().putAttribute("eval.value", result);
                x.putAttribute("eval.value", result);
                return false;
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLBinaryOpExpr x) {
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        left.accept(visitor);
        if (!left.getAttributes().containsKey("eval.value")) {
            return false;
        }
        right.accept(visitor);
        if (!right.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object value = null;
        switch (x.getOperator()) {
            case Add: {
                value = SQLEvalVisitorUtils.add(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case Subtract: {
                value = SQLEvalVisitorUtils.sub(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case Multiply: {
                value = SQLEvalVisitorUtils.multi(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case Divide: {
                value = SQLEvalVisitorUtils.div(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case GreaterThan: {
                value = SQLEvalVisitorUtils.gt(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case GreaterThanOrEqual: {
                value = SQLEvalVisitorUtils.gteq(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case LessThan: {
                value = SQLEvalVisitorUtils.lt(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case LessThanOrEqual: {
                value = SQLEvalVisitorUtils.lteq(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case Is: {
                value = SQLEvalVisitorUtils.eq(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case IsNot: {
                value = !SQLEvalVisitorUtils.eq(left.getAttribute("eval.value"), right.getAttributes().get("eval.value"));
                x.putAttribute("eval.value", value);
                break;
            }
            case RegExp: 
            case RLike: {
                String pattern = SQLEvalVisitorUtils._string(right.getAttributes().get("eval.value"));
                String input = SQLEvalVisitorUtils._string(left.getAttributes().get("eval.value"));
                boolean matchResult = Pattern.matches(pattern, input);
                x.putAttribute("eval.value", matchResult);
                break;
            }
            case NotRegExp: 
            case NotRLike: {
                String pattern = SQLEvalVisitorUtils._string(right.getAttributes().get("eval.value"));
                String input = SQLEvalVisitorUtils._string(left.getAttributes().get("eval.value"));
                boolean matchResult = !Pattern.matches(pattern, input);
                x.putAttribute("eval.value", matchResult);
                break;
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLNumericLiteralExpr x) {
        x.getAttributes().put("eval.value", x.getNumber());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLVariantRefExpr x) {
        boolean containsValue;
        if (!"?".equals(x.getName())) {
            return false;
        }
        Map<String, Object> attributes = x.getAttributes();
        int varIndex = x.getIndex();
        if (varIndex != -1 && visitor.getParameters().size() > varIndex && !(containsValue = attributes.containsKey("eval.value"))) {
            Object value = visitor.getParameters().get(varIndex);
            attributes.put("eval.value", value);
        }
        return false;
    }

    public static Boolean _bool(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() == 1;
        }
        throw new IllegalArgumentException();
    }

    public static String _string(Object val) {
        Object value = val;
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Byte _byte(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        return ((Number)val).byteValue();
    }

    public static Short _short(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        return ((Number)val).shortValue();
    }

    public static Integer _int(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return ((Number)val).intValue();
    }

    public static Long _long(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        return ((Number)val).longValue();
    }

    public static Float _float(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        return Float.valueOf(((Number)val).floatValue());
    }

    public static Double _double(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        return ((Number)val).doubleValue();
    }

    public static BigInteger _bigInt(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof String) {
            return new BigInteger((String)val);
        }
        return BigInteger.valueOf(((Number)val).longValue());
    }

    public static Date _date(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof Number) {
            return new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            return SQLEvalVisitorUtils._date((String)val);
        }
        throw new DruidRuntimeException("can cast to date");
    }

    public static Date _date(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        String format = text.length() == "yyyy-MM-dd".length() ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
        try {
            return new SimpleDateFormat(format).parse(text);
        }
        catch (ParseException e) {
            throw new DruidRuntimeException("format : " + format + ", value : " + text, e);
        }
    }

    public static BigDecimal _decimal(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        if (val instanceof Float) {
            return new BigDecimal(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return new BigDecimal((Double)val);
        }
        return BigDecimal.valueOf(((Number)val).longValue());
    }

    public static Object _sum(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).add(SQLEvalVisitorUtils._decimal(b));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).add(SQLEvalVisitorUtils._bigInt(b));
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) + SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) + SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) + SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) + SQLEvalVisitorUtils._byte(b);
        }
        throw new IllegalArgumentException();
    }

    public static Object div(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).divide(SQLEvalVisitorUtils._decimal(b));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).divide(SQLEvalVisitorUtils._bigInt(b));
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) / SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) / SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) / SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) / SQLEvalVisitorUtils._byte(b);
        }
        throw new IllegalArgumentException();
    }

    public static boolean gt(Object a, Object b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).compareTo(SQLEvalVisitorUtils._decimal(b)) > 0;
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).compareTo(SQLEvalVisitorUtils._bigInt(b)) > 0;
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) > SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) > SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) > SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) > SQLEvalVisitorUtils._byte(b);
        }
        if (a instanceof Date || b instanceof Date) {
            Date d2;
            Date d1 = SQLEvalVisitorUtils._date(a);
            if (d1 == (d2 = SQLEvalVisitorUtils._date(b))) {
                return false;
            }
            if (d1 == null) {
                return false;
            }
            if (d2 == null) {
                return true;
            }
            return d1.compareTo(d2) > 0;
        }
        throw new IllegalArgumentException();
    }

    public static boolean gteq(Object a, Object b) {
        if (SQLEvalVisitorUtils.eq(a, b)) {
            return true;
        }
        return SQLEvalVisitorUtils.gt(a, b);
    }

    public static boolean lt(Object a, Object b) {
        if (a == null) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).compareTo(SQLEvalVisitorUtils._decimal(b)) < 0;
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).compareTo(SQLEvalVisitorUtils._bigInt(b)) < 0;
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) < SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) < SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) < SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) < SQLEvalVisitorUtils._byte(b);
        }
        if (a instanceof Date || b instanceof Date) {
            Date d2;
            Date d1 = SQLEvalVisitorUtils._date(a);
            if (d1 == (d2 = SQLEvalVisitorUtils._date(b))) {
                return false;
            }
            if (d1 == null) {
                return true;
            }
            if (d2 == null) {
                return false;
            }
            return d1.compareTo(d2) < 0;
        }
        throw new IllegalArgumentException();
    }

    public static boolean lteq(Object a, Object b) {
        if (SQLEvalVisitorUtils.eq(a, b)) {
            return true;
        }
        return SQLEvalVisitorUtils.lt(a, b);
    }

    public static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).compareTo(SQLEvalVisitorUtils._decimal(b)) == 0;
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).compareTo(SQLEvalVisitorUtils._bigInt(b)) == 0;
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) == SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) == SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) == SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) == SQLEvalVisitorUtils._byte(b);
        }
        if (a instanceof Date || b instanceof Date) {
            Date d2;
            Date d1 = SQLEvalVisitorUtils._date(a);
            if (d1 == (d2 = SQLEvalVisitorUtils._date(b))) {
                return true;
            }
            if (d1 == null || d2 == null) {
                return false;
            }
            return d1.equals(d2);
        }
        if (a instanceof String || b instanceof String) {
            return SQLEvalVisitorUtils._string(a).equals(SQLEvalVisitorUtils._string(b));
        }
        throw new IllegalArgumentException();
    }

    public static Object add(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).add(SQLEvalVisitorUtils._decimal(b));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).add(SQLEvalVisitorUtils._bigInt(b));
        }
        if (a instanceof Double || b instanceof Double) {
            return SQLEvalVisitorUtils._double(a) + SQLEvalVisitorUtils._double(b);
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(SQLEvalVisitorUtils._float(a).floatValue() + SQLEvalVisitorUtils._float(b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) + SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) + SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) + SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) + SQLEvalVisitorUtils._byte(b);
        }
        if (a instanceof String || b instanceof String) {
            return SQLEvalVisitorUtils._string(a) + SQLEvalVisitorUtils._string(b);
        }
        throw new IllegalArgumentException();
    }

    public static Object sub(Object a, Object b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).subtract(SQLEvalVisitorUtils._decimal(b));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).subtract(SQLEvalVisitorUtils._bigInt(b));
        }
        if (a instanceof Double || b instanceof Double) {
            return SQLEvalVisitorUtils._double(a) - SQLEvalVisitorUtils._double(b);
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(SQLEvalVisitorUtils._float(a).floatValue() - SQLEvalVisitorUtils._float(b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) - SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) - SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) - SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) - SQLEvalVisitorUtils._byte(b);
        }
        throw new IllegalArgumentException();
    }

    public static Object multi(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return SQLEvalVisitorUtils._decimal(a).multiply(SQLEvalVisitorUtils._decimal(b));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return SQLEvalVisitorUtils._bigInt(a).multiply(SQLEvalVisitorUtils._bigInt(b));
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils._long(a) * SQLEvalVisitorUtils._long(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return SQLEvalVisitorUtils._int(a) * SQLEvalVisitorUtils._int(b);
        }
        if (a instanceof Short || b instanceof Short) {
            return SQLEvalVisitorUtils._short(a) * SQLEvalVisitorUtils._short(b);
        }
        if (a instanceof Byte || b instanceof Byte) {
            return SQLEvalVisitorUtils._byte(a) * SQLEvalVisitorUtils._byte(b);
        }
        throw new IllegalArgumentException();
    }
}

