/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.profile.ProfileStat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class WebURIStat {
    private final String uri;
    private volatile int runningCount;
    private volatile int concurrentMax;
    private volatile long requestCount;
    private volatile long requestTimeNano;
    static final AtomicIntegerFieldUpdater<WebURIStat> runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater<WebURIStat> concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "concurrentMax");
    static final AtomicLongFieldUpdater<WebURIStat> requestCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestCount");
    static final AtomicLongFieldUpdater<WebURIStat> requestTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestTimeNano");
    private volatile long jdbcFetchRowCount;
    private volatile long jdbcFetchRowPeak;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcFetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcFetchRowCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcFetchRowPeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcFetchRowPeak");
    private volatile long jdbcUpdateCount;
    private volatile long jdbcUpdatePeak;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcUpdateCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcUpdateCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcUpdatePeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcUpdatePeak");
    private volatile long jdbcExecuteCount;
    private volatile long jdbcExecuteErrorCount;
    private volatile long jdbcExecutePeak;
    private volatile long jdbcExecuteTimeNano;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteErrorCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecutePeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecutePeak");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteTimeNano");
    private volatile long jdbcCommitCount;
    private volatile long jdbcRollbackCount;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcCommitCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcCommitCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcRollbackCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcRollbackCount");
    private volatile long jdbcPoolConnectionOpenCount;
    private volatile long jdbcPoolConnectionCloseCount;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcPoolConnectionOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcPoolConnectionOpenCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcPoolConnectionCloseCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcPoolConnectionCloseCount");
    private volatile long jdbcResultSetOpenCount;
    private volatile long jdbcResultSetCloseCount;
    private volatile long errorCount;
    private volatile long lastAccessTimeMillis = -1L;
    private volatile ProfileStat profiletat;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcResultSetOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcResultSetOpenCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcResultSetCloseCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcResultSetCloseCount");
    static final AtomicLongFieldUpdater<WebURIStat> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "errorCount");
    static final AtomicReferenceFieldUpdater<WebURIStat, ProfileStat> profiletatUpdater = AtomicReferenceFieldUpdater.newUpdater(WebURIStat.class, ProfileStat.class, "profiletat");
    private static final ThreadLocal<WebURIStat> currentLocal = new ThreadLocal();

    public WebURIStat(String uri) {
        this.uri = uri;
    }

    public static WebURIStat current() {
        return currentLocal.get();
    }

    public String getUri() {
        return this.uri;
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = runningCountUpdater.incrementAndGet(this);
        while (running > (max = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, max, running)) {
        }
        requestCountUpdater.incrementAndGet(this);
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.setLastAccessTimeMillis(requestStat.getStartMillis());
        }
    }

    public void afterInvoke(Throwable error, long nanos) {
        WebRequestStat localStat;
        runningCountUpdater.decrementAndGet(this);
        requestTimeNanoUpdater.addAndGet(this, nanos);
        if (error != null) {
            errorCountUpdater.incrementAndGet(this);
        }
        if ((localStat = WebRequestStat.current()) != null) {
            long peak;
            long fetchRowCount = localStat.getJdbcFetchRowCount();
            this.addJdbcFetchRowCount(fetchRowCount);
            while (fetchRowCount > (peak = jdbcFetchRowPeakUpdater.get(this)) && !jdbcFetchRowPeakUpdater.compareAndSet(this, peak, fetchRowCount)) {
            }
            long executeCount = localStat.getJdbcExecuteCount();
            this.addJdbcExecuteCount(executeCount);
            while (executeCount > (peak = jdbcExecutePeakUpdater.get(this)) && !jdbcExecutePeakUpdater.compareAndSet(this, peak, executeCount)) {
            }
            long updateCount = localStat.getJdbcUpdateCount();
            this.addJdbcUpdateCount(updateCount);
            while (updateCount > (peak = jdbcUpdatePeakUpdater.get(this)) && !jdbcUpdatePeakUpdater.compareAndSet(this, peak, updateCount)) {
            }
            jdbcExecuteErrorCountUpdater.addAndGet(this, localStat.getJdbcExecuteErrorCount());
            jdbcExecuteTimeNanoUpdater.addAndGet(this, localStat.getJdbcExecuteTimeNano());
            this.addJdbcPoolConnectionOpenCount(localStat.getJdbcPoolConnectionOpenCount());
            this.addJdbcPoolConnectionCloseCount(localStat.getJdbcPoolConnectionCloseCount());
            this.addJdbcResultSetOpenCount(localStat.getJdbcResultSetOpenCount());
            this.addJdbcResultSetCloseCount(localStat.getJdbcResultSetCloseCount());
        }
        currentLocal.set(null);
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRequestTimeNano() {
        return this.requestTimeNano;
    }

    public long getRequestTimeMillis() {
        return this.getRequestTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        jdbcFetchRowCountUpdater.addAndGet(this, delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount;
    }

    public long getJdbcFetchRowPeak() {
        return this.jdbcFetchRowPeak;
    }

    public void addJdbcUpdateCount(long updateCount) {
        jdbcUpdateCountUpdater.addAndGet(this, updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount;
    }

    public long getJdbcUpdatePeak() {
        return this.jdbcUpdatePeak;
    }

    public void incrementJdbcExecuteCount() {
        jdbcExecuteCountUpdater.incrementAndGet(this);
    }

    public void addJdbcExecuteCount(long executeCount) {
        jdbcExecuteCountUpdater.addAndGet(this, executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount;
    }

    public long getJdbcExecuteErrorCount() {
        return this.jdbcExecuteErrorCount;
    }

    public long getJdbcExecutePeak() {
        return this.jdbcExecutePeak;
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano;
    }

    public void incrementJdbcCommitCount() {
        jdbcCommitCountUpdater.incrementAndGet(this);
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount;
    }

    public void incrementJdbcRollbackCount() {
        jdbcRollbackCountUpdater.incrementAndGet(this);
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount;
    }

    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    public Date getLastAccessTime() {
        if (this.lastAccessTimeMillis < 0L) {
            return null;
        }
        return new Date(this.lastAccessTimeMillis);
    }

    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getJdbcPoolConnectionOpenCount() {
        return this.jdbcPoolConnectionOpenCount;
    }

    public void addJdbcPoolConnectionOpenCount(long delta) {
        jdbcPoolConnectionOpenCountUpdater.addAndGet(this, delta);
    }

    public void incrementJdbcPoolConnectionOpenCount() {
        jdbcPoolConnectionOpenCountUpdater.incrementAndGet(this);
    }

    public long getJdbcPoolConnectionCloseCount() {
        return this.jdbcPoolConnectionCloseCount;
    }

    public void addJdbcPoolConnectionCloseCount(long delta) {
        jdbcPoolConnectionCloseCountUpdater.addAndGet(this, delta);
    }

    public void incrementJdbcPoolConnectionCloseCount() {
        jdbcPoolConnectionCloseCountUpdater.incrementAndGet(this);
    }

    public long getJdbcResultSetOpenCount() {
        return this.jdbcResultSetOpenCount;
    }

    public void addJdbcResultSetOpenCount(long delta) {
        jdbcResultSetOpenCountUpdater.addAndGet(this, delta);
    }

    public long getJdbcResultSetCloseCount() {
        return this.jdbcResultSetCloseCount;
    }

    public void addJdbcResultSetCloseCount(long delta) {
        jdbcResultSetCloseCountUpdater.addAndGet(this, delta);
    }

    public ProfileStat getProfiletat() {
        if (this.profiletat != null) {
            return this.profiletat;
        }
        profiletatUpdater.compareAndSet(this, null, new ProfileStat());
        return this.profiletat;
    }

    public Map<String, Object> getStatData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("URI", this.getUri());
        data.put("RunningCount", this.getRunningCount());
        data.put("ConcurrentMax", this.getConcurrentMax());
        data.put("RequestCount", this.getRequestCount());
        data.put("RequestTimeMillis", this.getRequestTimeMillis());
        data.put("ErrorCount", this.getErrorCount());
        data.put("LastAccessTime", this.getLastAccessTime());
        data.put("JdbcCommitCount", this.getJdbcCommitCount());
        data.put("JdbcRollbackCount", this.getJdbcRollbackCount());
        data.put("JdbcExecuteCount", this.getJdbcExecuteCount());
        data.put("JdbcExecuteErrorCount", this.getJdbcExecuteErrorCount());
        data.put("JdbcExecutePeak", this.getJdbcExecutePeak());
        data.put("JdbcExecuteTimeMillis", this.getJdbcExecuteTimeMillis());
        data.put("JdbcFetchRowCount", this.getJdbcFetchRowCount());
        data.put("JdbcFetchRowPeak", this.getJdbcFetchRowPeak());
        data.put("JdbcUpdateCount", this.getJdbcUpdateCount());
        data.put("JdbcUpdatePeak", this.getJdbcUpdatePeak());
        data.put("JdbcPoolConnectionOpenCount", this.getJdbcPoolConnectionOpenCount());
        data.put("JdbcPoolConnectionCloseCount", this.getJdbcPoolConnectionCloseCount());
        data.put("JdbcResultSetOpenCount", this.getJdbcResultSetOpenCount());
        data.put("JdbcResultSetCloseCount", this.getJdbcResultSetCloseCount());
        data.put("Profiles", this.getProfiletat().getStatData());
        return data;
    }
}

