/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.service.impl;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.impl.AbstractService;
import com.alibaba.dubbo.governance.sync.util.Pair;
import com.alibaba.dubbo.governance.sync.util.SyncUtils;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerServiceImpl
extends AbstractService
implements ConsumerService {
    public List<Consumer> findByService(String service) {
        return SyncUtils.url2ConsumerList((Map)this.findConsumerUrlByService(service));
    }

    public Consumer findConsumer(Long id) {
        return SyncUtils.url2Consumer((Pair)this.findConsumerUrl(id));
    }

    private Pair<Long, URL> findConsumerUrl(Long id) {
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), (String)"consumers", (Long)id);
    }

    public List<Consumer> findAll() {
        return SyncUtils.url2ConsumerList((Map)this.findAllConsumerUrl());
    }

    private Map<Long, URL> findAllConsumerUrl() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findAddresses() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (null == consumerUrls) {
            return ret;
        }
        for (Map.Entry e1 : consumerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getAddress();
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<String> findAddressesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        for (Map.Entry e1 : consumerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                String addr;
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application")) || (addr = u.getAddress()) == null) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    public List<String> findAddressesByService(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (null == consumerUrls) {
            return ret;
        }
        for (Map.Entry e2 : ((Map)consumerUrls.get(service)).entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getAddress();
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<Consumer> findByAddress(String consumerAddress) {
        return SyncUtils.url2ConsumerList((Map)this.findConsumerUrlByAddress(consumerAddress));
    }

    public List<String> findServicesByAddress(String address) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (consumerUrls == null || address == null || address.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : consumerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!address.equals(u.getAddress())) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    private Map<Long, URL> findConsumerUrlByAddress(String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        filter.put(".address", address);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findApplications() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (consumerUrls == null) {
            return ret;
        }
        for (Map.Entry e1 : consumerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getParameter("application");
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<String> findApplicationsByServiceName(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (consumerUrls == null) {
            return ret;
        }
        Map value = (Map)consumerUrls.get(service);
        if (value == null) {
            return ret;
        }
        for (Map.Entry e2 : value.entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getParameter("application");
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<Consumer> findByApplication(String application) {
        return SyncUtils.url2ConsumerList((Map)this.findConsumerUrlByApplication(application));
    }

    private Map<Long, URL> findConsumerUrlByApplication(String application) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        filter.put("application", application);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findServicesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (consumerUrls == null || application == null || application.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : consumerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application"))) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    public List<String> findServices() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap consumerUrls = (ConcurrentMap)this.getRegistryCache().get("consumers");
        if (consumerUrls != null) {
            ret.addAll(consumerUrls.keySet());
        }
        return ret;
    }

    public Map<Long, URL> findConsumerUrlByService(String service) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        filter.put(".service", service);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }
}

