/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.sync;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.web.common.pulltool.Tool;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.RegistryService;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryServerSync
implements InitializingBean,
DisposableBean,
NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServerSync.class);
    private static final URL SUBSCRIBE = new URL("admin", NetUtils.getLocalHost(), 0, "", new String[]{"interface", "*", "group", "*", "version", "*", "classifier", "*", "category", "providers,consumers,routers,configurators", "enabled", "*", "check", String.valueOf(false)});
    private static final AtomicLong ID = new AtomicLong();
    @Autowired
    private RegistryService registryService;
    private final ConcurrentMap<String, ConcurrentMap<String, Map<Long, URL>>> registryCache = new ConcurrentHashMap();

    public ConcurrentMap<String, ConcurrentMap<String, Map<Long, URL>>> getRegistryCache() {
        return this.registryCache;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Init Dubbo Admin Sync Cache...");
        this.registryService.subscribe(SUBSCRIBE, (NotifyListener)this);
    }

    public void destroy() throws Exception {
        this.registryService.unsubscribe(SUBSCRIBE, (NotifyListener)this);
    }

    public void notify(List<URL> urls) {
        Map services;
        String category;
        if (urls == null || urls.isEmpty()) {
            return;
        }
        HashMap<String, AbstractMap> categories = new HashMap<String, AbstractMap>();
        for (URL uRL : urls) {
            String service;
            HashMap<Long, URL> ids;
            category = uRL.getParameter("category", "providers");
            if ("empty".equalsIgnoreCase(uRL.getProtocol())) {
                services = (ConcurrentMap)this.registryCache.get(category);
                if (services == null) continue;
                String group = uRL.getParameter("group");
                String version = uRL.getParameter("version");
                if (!"*".equals(group) && !"*".equals(version)) {
                    services.remove(uRL.getServiceKey());
                    continue;
                }
                for (Map.Entry serviceEntry : services.entrySet()) {
                    String service2 = (String)serviceEntry.getKey();
                    if (!Tool.getInterface((String)service2).equals(uRL.getServiceInterface()) || !"*".equals(group) && !StringUtils.isEquals((String)group, (String)Tool.getGroup((String)service2)) || !"*".equals(version) && !StringUtils.isEquals((String)version, (String)Tool.getVersion((String)service2))) continue;
                    services.remove(service2);
                }
                continue;
            }
            services = (HashMap)categories.get(category);
            if (services == null) {
                services = new HashMap();
                categories.put(category, (AbstractMap)services);
            }
            if ((ids = (HashMap<Long, URL>)services.get(service = uRL.getServiceKey())) == null) {
                ids = new HashMap<Long, URL>();
                services.put(service, ids);
            }
            ids.put(ID.incrementAndGet(), uRL);
        }
        for (Map.Entry entry : categories.entrySet()) {
            category = (String)entry.getKey();
            services = (ConcurrentMap)this.registryCache.get(category);
            if (services == null) {
                services = new ConcurrentHashMap();
                this.registryCache.put(category, services);
            }
            services.putAll((Map)entry.getValue());
        }
    }
}

