/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.interceptor;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.registry.common.domain.User;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

public class ServicePrivilegeCheckValve
extends AbstractValve {
    private static final Logger logger = LoggerFactory.getLogger(ServicePrivilegeCheckValve.class);
    @Autowired
    private HttpServletRequest request;

    protected void init() throws Exception {
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        User user = (User)this.request.getSession().getAttribute("currentUser");
        this.invokeCheckServicePrivilege(user);
        pipelineContext.invokeNext();
    }

    private void invokeCheckServicePrivilege(User user) {
        String type;
        TurbineRunData rundata = TurbineUtil.getTurbineRunData((HttpServletRequest)this.request);
        HttpSession session = this.request.getSession();
        Map requestMapping = this.request.getParameterMap();
        String returnURL = "";
        returnURL = session.getAttribute("returnURL") == null ? this.request.getContextPath() : (String)session.getAttribute("returnURL");
        if (((String[])requestMapping.get("service")).length > 0) {
            boolean exclude;
            String service = ((String[])requestMapping.get("service"))[0];
            String method = "index";
            if (((String[])requestMapping.get("_method")).length > 0) {
                method = ((String[])requestMapping.get("_method"))[0];
            }
            boolean bl = exclude = "index".equals(method) || "show".equals(method);
            if (!exclude && user != null && !user.hasServicePrivilege(service)) {
                this.request.setAttribute("returnURL", (Object)returnURL);
                this.redirectToNoRight(rundata);
            }
        }
        String string = type = ((String[])requestMapping.get("_type")).length == 0 ? null : ((String[])requestMapping.get("_type"))[0];
        if (!"noServicePrivilege".equals(type)) {
            session.setAttribute("returnURL", (Object)this.request.getRequestURI());
        }
    }

    private void redirectToNoRight(TurbineRunData rundata) {
        if (logger.isInfoEnabled()) {
            logger.info("No right to access: " + this.request.getRequestURI());
        }
        rundata.getParameters().setString("returnURL1", (String)rundata.getRequest().getAttribute("returnURL"));
        rundata.setRedirectLocation("http://localhost:8080/governance/noServicePrivilege?returnURL=" + rundata.getRequest().getAttribute("returnURL"));
    }
}

