/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.module.screen;

import com.alibaba.dubbo.common.utils.CompatibleTypeUtils;
import com.alibaba.dubbo.governance.biz.common.i18n.MessageResourceService;
import com.alibaba.dubbo.governance.web.common.pulltool.RootContextPath;
import com.alibaba.dubbo.registry.common.domain.User;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class Restful {
    protected static final Logger logger = Logger.getLogger(Restful.class);
    protected static final Pattern SPACE_SPLIT_PATTERN = Pattern.compile("\\s+");
    @Autowired
    private MessageResourceService messageResourceService;
    protected String role = null;
    protected String operator = null;
    protected User currentUser = null;
    protected String operatorAddress = null;
    protected String currentRegistry = null;

    public String getMessage(String key, Object ... args) {
        return this.messageResourceService.getMessage(key, args);
    }

    public void execute(Map<String, Object> context) throws Throwable {
        block41: {
            if (context.get("currentUser") != null) {
                User user;
                this.currentUser = user = (User)context.get("currentUser");
                this.operator = user.getUsername();
                this.role = user.getRole();
                context.put("currentUser", user);
            }
            this.operatorAddress = (String)context.get("request.remoteHost");
            context.put("operator", this.operator);
            context.put("operatorAddress", this.operatorAddress);
            context.put("currentRegistry", this.currentRegistry);
            String httpMethod = (String)context.get("request.method");
            String method = (String)context.get("_method");
            String contextPath = (String)context.get("request.contextPath");
            context.put("rootContextPath", new RootContextPath(contextPath));
            if (method == null || method.length() == 0) {
                String id = (String)context.get("id");
                method = id == null || id.length() == 0 ? "index" : "show";
            }
            if ("index".equals(method)) {
                if ("post".equalsIgnoreCase(httpMethod)) {
                    method = "create";
                }
            } else if ("show".equals(method)) {
                if ("put".equalsIgnoreCase(httpMethod) || "post".equalsIgnoreCase(httpMethod)) {
                    method = "update";
                } else if ("delete".equalsIgnoreCase(httpMethod)) {
                    method = "delete";
                }
            }
            context.put("_method", method);
            try {
                Object r;
                Method m;
                block40: {
                    m = null;
                    try {
                        m = this.getClass().getMethod(method, Map.class);
                    }
                    catch (NoSuchMethodException e) {
                        for (Method mtd : this.getClass().getMethods()) {
                            if (!Modifier.isPublic(mtd.getModifiers()) || !mtd.getName().equals(method)) continue;
                            m = mtd;
                            break;
                        }
                        if (m != null) break block40;
                        throw e;
                    }
                }
                if (m.getParameterTypes().length > 2) {
                    throw new IllegalStateException("Unsupport restful method " + m);
                }
                if (m.getParameterTypes().length == 2 && (m.getParameterTypes()[0].equals(Map.class) || !m.getParameterTypes()[1].equals(Map.class))) {
                    throw new IllegalStateException("Unsupport restful method " + m);
                }
                if (m.getParameterTypes().length == 0) {
                    r = m.invoke((Object)this, new Object[0]);
                } else {
                    Object value;
                    Class<?> t = m.getParameterTypes()[0];
                    if (Map.class.equals(t)) {
                        value = context;
                    } else if (Restful.isPrimitive(t)) {
                        String id = (String)context.get("id");
                        value = Restful.convertPrimitive(t, (String)id);
                    } else if (t.isArray() && Restful.isPrimitive(t.getComponentType())) {
                        String id = (String)context.get("id");
                        String[] ids = id == null ? new String[]{} : id.split("[.+]+");
                        value = Array.newInstance(t.getComponentType(), ids.length);
                        for (int i = 0; i < ids.length; ++i) {
                            Array.set(value, i, Restful.convertPrimitive(t.getComponentType(), (String)ids[i]));
                        }
                    } else {
                        value = t.newInstance();
                        for (Method mtd : t.getMethods()) {
                            if (!Modifier.isPublic(mtd.getModifiers()) || !mtd.getName().startsWith("set") || mtd.getParameterTypes().length != 1) continue;
                            String p = mtd.getName().substring(3, 4).toLowerCase() + mtd.getName().substring(4);
                            Object v = context.get(p);
                            if (v == null) {
                                if ("operator".equals(p)) {
                                    v = this.operator;
                                } else if ("operatorAddress".equals(p)) {
                                    v = (String)context.get("request.remoteHost");
                                }
                            }
                            if (v == null) continue;
                            try {
                                mtd.invoke(value, CompatibleTypeUtils.compatibleTypeConvert((Object)v, mtd.getParameterTypes()[0]));
                            }
                            catch (Throwable e) {
                                logger.warn((Object)e.getMessage(), e);
                            }
                        }
                    }
                    r = m.getParameterTypes().length == 1 ? m.invoke((Object)this, value) : m.invoke((Object)this, value, context);
                }
                if (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class) {
                    context.put("rundata.layout", "redirect");
                    context.put("rundata.target", "redirect");
                    context.put("success", r == null || (Boolean)r != false);
                    if (context.get("redirect") == null) {
                        context.put("redirect", this.getDefaultRedirect(context, method));
                    }
                } else if (m.getReturnType() == String.class) {
                    String redirect = (String)r;
                    if (redirect == null) {
                        redirect = this.getDefaultRedirect(context, method);
                    }
                    if (context.get("chain") != null) {
                        context.put("rundata.layout", "home");
                        context.put("rundata.target", "home");
                    } else {
                        context.put("rundata.redirect", redirect);
                    }
                } else {
                    context.put("rundata.layout", method);
                    context.put("rundata.target", context.get("rundata.target") + "/" + method);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof InvocationTargetException)) break block41;
                throw ((InvocationTargetException)e).getTargetException();
            }
        }
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class;
    }

    private static Object convertPrimitive(Class<?> cls, String value) {
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return value == null || value.length() == 0 ? false : Boolean.valueOf(value);
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return value == null || value.length() == 0 ? (byte)0 : Byte.valueOf(value);
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.valueOf(value == null || value.length() == 0 ? (char)'\u0000' : value.charAt(0));
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return value == null || value.length() == 0 ? (short)0 : Short.valueOf(value);
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return value == null || value.length() == 0 ? 0 : Integer.valueOf(value);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return value == null || value.length() == 0 ? 0L : Long.valueOf(value);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.valueOf(value == null || value.length() == 0 ? 0.0f : Float.valueOf(value).floatValue());
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return value == null || value.length() == 0 ? 0.0 : Double.valueOf(value);
        }
        return value;
    }

    private String getDefaultRedirect(Map<String, Object> context, String operate) {
        String defaultRedirect = (String)context.get("defaultRedirect");
        return defaultRedirect;
    }
}

