/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.service.RouteService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Access;
import com.alibaba.dubbo.registry.common.domain.Route;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accesses
extends Restful {
    @Autowired
    private RouteService routeService;
    @Autowired
    private ProviderService providerService;
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3}$");
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern ALL_IP_PATTERN = Pattern.compile("0{1,3}(\\.0{1,3}){3}$");

    public void index(Map<String, Object> context) throws Exception {
        String service = (String)context.get("service");
        String address = (String)context.get("address");
        address = Tool.getIP((String)address);
        List routes = service != null && service.length() > 0 ? this.routeService.findForceRouteByService(service) : (address != null && address.length() > 0 ? this.routeService.findForceRouteByAddress(address) : this.routeService.findAllForceRoute());
        ArrayList<Access> accesses = new ArrayList<Access>();
        if (routes == null) {
            context.put("accesses", accesses);
            return;
        }
        for (Route route : routes) {
            Access access;
            Map rule = RouteRule.parseRule((String)route.getMatchRule());
            RouteRule.MatchPair pair = (RouteRule.MatchPair)rule.get("consumer.host");
            if (pair == null) continue;
            for (String host : pair.getMatches()) {
                access = new Access();
                access.setAddress(host);
                access.setService(route.getService());
                access.setAllow(false);
                accesses.add(access);
            }
            for (String host : pair.getUnmatches()) {
                access = new Access();
                access.setAddress(host);
                access.setService(route.getService());
                access.setAllow(true);
                accesses.add(access);
            }
        }
        context.put("accesses", accesses);
    }

    public void add(Map<String, Object> context) {
        List serviceList = Tool.sortSimpleName((List)this.providerService.findServices());
        context.put("serviceList", serviceList);
    }

    public boolean create(Map<String, Object> context) throws Exception {
        String addr = (String)context.get("consumerAddress");
        String services = (String)context.get("service");
        Set consumerAddresses = this.toAddr(addr);
        Set aimServices = this.toService(services);
        for (String aimService : aimServices) {
            boolean isFirst = false;
            List routes = this.routeService.findForceRouteByService(aimService);
            Route route = null;
            if (routes == null || routes.size() == 0) {
                isFirst = true;
                route = new Route();
                route.setService(aimService);
                route.setForce(true);
                route.setName(aimService + " blackwhitelist");
                route.setFilterRule("false");
                route.setEnabled(true);
            } else {
                route = (Route)routes.get(0);
            }
            Map<String, RouteRule.MatchPair> when = null;
            RouteRule.MatchPair matchPair = null;
            if (isFirst) {
                when = new HashMap();
                matchPair = new RouteRule.MatchPair(new HashSet(), new HashSet());
                when.put("consumer.host", matchPair);
            } else {
                when = RouteRule.parseRule((String)route.getMatchRule());
                matchPair = (RouteRule.MatchPair)when.get("consumer.host");
            }
            for (String consumerAddress : consumerAddresses) {
                if (Boolean.valueOf((String)context.get("allow")).booleanValue()) {
                    matchPair.getUnmatches().add(Tool.getIP((String)consumerAddress));
                    continue;
                }
                matchPair.getMatches().add(Tool.getIP((String)consumerAddress));
            }
            StringBuilder sb = new StringBuilder();
            RouteRule.contidionToString((StringBuilder)sb, when);
            route.setMatchRule(sb.toString());
            route.setUsername(this.operator);
            if (isFirst) {
                this.routeService.createRoute(route);
                continue;
            }
            this.routeService.updateRoute(route);
        }
        return true;
    }

    private Set<String> toAddr(String addr) throws IOException {
        String line;
        HashSet<String> consumerAddresses = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new StringReader(addr));
        while (null != (line = reader.readLine())) {
            String[] split;
            for (String s : split = line.split("[\\s,;]+")) {
                if (s.length() == 0) continue;
                if (!IP_PATTERN.matcher(s).matches()) {
                    throw new IllegalStateException("illegal IP: " + s);
                }
                if (LOCAL_IP_PATTERN.matcher(s).matches() || ALL_IP_PATTERN.matcher(s).matches()) {
                    throw new IllegalStateException("local IP or any host ip is illegal: " + s);
                }
                consumerAddresses.add(s);
            }
        }
        return consumerAddresses;
    }

    private Set<String> toService(String services) throws IOException {
        String line;
        HashSet<String> aimServices = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new StringReader(services));
        while (null != (line = reader.readLine())) {
            String[] split;
            for (String s : split = line.split("[\\s,;]+")) {
                if (s.length() == 0) continue;
                aimServices.add(s);
            }
        }
        return aimServices;
    }

    public boolean delete(Map<String, Object> context) throws ParseException {
        String accesses = (String)context.get("accesses");
        String[] temp = accesses.split(" ");
        HashMap prepareToDeleate = new HashMap();
        for (String s : temp) {
            String service = s.split("=")[0];
            String address = s.split("=")[1];
            Set addresses = (Set)prepareToDeleate.get(service);
            if (addresses == null) {
                prepareToDeleate.put(service, new HashSet());
                addresses = (Set)prepareToDeleate.get(service);
            }
            addresses.add(address);
        }
        for (Map.Entry entry : prepareToDeleate.entrySet()) {
            String service = (String)entry.getKey();
            List routes = this.routeService.findForceRouteByService(service);
            if (routes == null || routes.size() == 0) continue;
            for (Route blackwhitelist : routes) {
                RouteRule.MatchPair pairs = (RouteRule.MatchPair)RouteRule.parseRule((String)blackwhitelist.getMatchRule()).get("consumer.host");
                HashSet matches = new HashSet();
                matches.addAll(pairs.getMatches());
                HashSet unmatches = new HashSet();
                unmatches.addAll(pairs.getUnmatches());
                block3: for (String pair : pairs.getMatches()) {
                    for (String address : (Set)entry.getValue()) {
                        if (!pair.equals(address)) continue;
                        matches.remove(pair);
                        continue block3;
                    }
                }
                block5: for (String pair : pairs.getUnmatches()) {
                    for (String address : (Set)entry.getValue()) {
                        if (!pair.equals(address)) continue;
                        unmatches.remove(pair);
                        continue block5;
                    }
                }
                if (matches.size() == 0 && unmatches.size() == 0) {
                    this.routeService.deleteRoute(blackwhitelist.getId());
                    continue;
                }
                HashMap<String, RouteRule.MatchPair> condition = new HashMap<String, RouteRule.MatchPair>();
                condition.put("consumer.host", new RouteRule.MatchPair(matches, unmatches));
                StringBuilder sb = new StringBuilder();
                RouteRule.contidionToString((StringBuilder)sb, condition);
                blackwhitelist.setMatchRule(sb.toString());
                this.routeService.updateRoute(blackwhitelist);
            }
        }
        return true;
    }

    public void show(Map<String, Object> context) {
    }

    public void edit(Map<String, Object> context) {
    }

    public String update(Map<String, Object> context) {
        return null;
    }
}

