/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.sysinfo.module.screen;

import com.alibaba.dubbo.common.logger.Level;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logs
extends Restful {
    private static final int SHOW_LOG_LENGTH = 30000;

    public void index(Map<String, Object> context) throws Exception {
        String modified;
        String content;
        long size;
        File file = LoggerFactory.getFile();
        if (file != null && file.exists()) {
            ByteBuffer bb;
            FileInputStream fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            size = channel.size();
            if (size <= 30000L) {
                bb = ByteBuffer.allocate((int)size);
                channel.read(bb, 0L);
            } else {
                int pos = (int)(size - 30000L);
                bb = ByteBuffer.allocate(30000);
                channel.read(bb, pos);
            }
            bb.flip();
            content = new String(bb.array()).replace("<", "&lt;").replace(">", "&gt;");
            modified = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(file.lastModified()));
        } else {
            size = 0L;
            content = "";
            modified = "Not exist";
        }
        Level level = LoggerFactory.getLevel();
        context.put("name", file == null ? "" : file.getAbsoluteFile());
        context.put("size", String.valueOf(size));
        context.put("level", level == null ? "" : level);
        context.put("modified", modified);
        context.put("content", content);
    }

    public boolean change(Map<String, Object> context) throws Exception {
        String contextLevel = (String)context.get("level");
        if (contextLevel == null || contextLevel.length() == 0) {
            context.put("message", this.getMessage("MissRequestParameters", new Object[]{"level"}));
            return false;
        }
        if (!"R".equals(this.role)) {
            context.put("message", this.getMessage("HaveNoRootPrivilege", new Object[0]));
            return false;
        }
        Level level = Level.valueOf((String)contextLevel);
        if (level != LoggerFactory.getLevel()) {
            LoggerFactory.setLevel((Level)level);
        }
        context.put("redirect", "/sysinfo/logs");
        return true;
    }
}

