/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common;

import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StatusManager {
    private static final StatusManager INSTANCE = new StatusManager();
    private final Map<String, StatusChecker> statusHandlers = new ConcurrentHashMap();

    public static StatusManager getInstance() {
        return INSTANCE;
    }

    private StatusManager() {
    }

    public void addStatusHandler(String name, StatusChecker statusHandler) {
        this.statusHandlers.put(name, statusHandler);
    }

    public void addStatusHandlers(Map<String, StatusChecker> statusHandlers) {
        this.statusHandlers.putAll(statusHandlers);
    }

    public void addStatusHandlers(Collection<StatusChecker> statusHandlers) {
        for (StatusChecker statusChecker : statusHandlers) {
            String name = statusChecker.getClass().getSimpleName();
            if (name.endsWith(StatusChecker.class.getSimpleName())) {
                name = name.substring(0, name.length() - StatusChecker.class.getSimpleName().length());
            }
            this.statusHandlers.put(name, statusChecker);
        }
    }

    public void removeStatusHandler(String name) {
        this.statusHandlers.remove(name);
    }

    public void clearStatusHandlers() {
        this.statusHandlers.clear();
    }

    public Map<String, Status> getStatusList() {
        return this.getStatusList(null);
    }

    public Map<String, Status> getStatusList(String[] excludes) {
        HashMap<String, Status> statuses = new HashMap<String, Status>();
        HashMap temp = new HashMap();
        temp.putAll(this.statusHandlers);
        if (excludes != null && excludes.length > 0) {
            for (String exclude : excludes) {
                temp.remove(exclude);
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            statuses.put((String)entry.getKey(), ((StatusChecker)entry.getValue()).check());
        }
        return statuses;
    }

    public static Status getStatusSummary(Map<String, Status> statusList) {
        return StatusManager.getSummaryStatus(statusList);
    }

    public static Status getSummaryStatus(Map<String, Status> statuses) {
        Status.Level level = Status.Level.OK;
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, Status> entry : statuses.entrySet()) {
            String key = entry.getKey();
            Status status = entry.getValue();
            Status.Level l = status.getLevel();
            if (Status.Level.ERROR.equals((Object)l)) {
                level = Status.Level.ERROR;
                if (msg.length() > 0) {
                    msg.append(",");
                }
                msg.append(key);
                continue;
            }
            if (!Status.Level.WARN.equals((Object)l)) continue;
            if (!Status.Level.ERROR.equals((Object)level)) {
                level = Status.Level.WARN;
            }
            if (msg.length() > 0) {
                msg.append(",");
            }
            msg.append(key);
        }
        return new Status(level, msg.toString());
    }
}

