/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.domain;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Entity;
import com.alibaba.dubbo.registry.common.domain.Provider;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Override
extends Entity {
    private static final long serialVersionUID = 114828505391757846L;
    private String service;
    private String params;
    private String application;
    private String address;
    private String username;
    private boolean enabled;

    public Override() {
    }

    public Override(long id) {
        super(Long.valueOf(id));
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "Override [service=" + this.service + ", params=" + this.params + ", application=" + this.application + ", address=" + this.address + ", username=" + this.username + ", enabled=" + this.enabled + "]";
    }

    public boolean isDefault() {
        return !(this.getAddress() != null && this.getAddress().length() != 0 && !"*".equals(this.getAddress()) && !"0.0.0.0".equals(this.getAddress()) || this.getApplication() != null && this.getApplication().length() != 0 && !"*".equals(this.getApplication()));
    }

    public boolean isMatch(String service, String address, String application) {
        return !(!this.isEnabled() || this.getParams() == null || this.getParams().length() <= 0 || !service.equals(this.getService()) || address != null && this.getAddress() != null && this.getAddress().length() != 0 && !this.getAddress().equals("*") && !this.getAddress().equals("0.0.0.0") && !this.getAddress().equals(address) || application != null && this.getApplication() != null && this.getApplication().length() != 0 && !this.getApplication().equals("*") && !this.getApplication().equals(application));
    }

    public boolean isUniqueMatch(Provider provider) {
        return this.isEnabled() && this.getParams() != null && this.getParams().length() > 0 && provider.getService().equals(this.getService()) && provider.getAddress().equals(this.getAddress());
    }

    public boolean isMatch(Provider provider) {
        return !(!this.isEnabled() || this.getParams() == null || this.getParams().length() <= 0 || !provider.getService().equals(this.getService()) || this.getAddress() != null && this.getAddress().length() != 0 && !this.getAddress().equals("*") && !this.getAddress().equals("0.0.0.0") && !this.getAddress().equals(provider.getAddress()) || this.getApplication() != null && this.getApplication().length() != 0 && !this.getApplication().equals("*") && !this.getApplication().equals(provider.getApplication()));
    }

    public boolean isUniqueMatch(Consumer consumer) {
        return this.isEnabled() && this.getParams() != null && this.getParams().length() > 0 && consumer.getService().equals(this.getService()) && consumer.getAddress().equals(this.getAddress());
    }

    public boolean isMatch(Consumer consumer) {
        return !(!this.isEnabled() || this.getParams() == null || this.getParams().length() <= 0 || !consumer.getService().equals(this.getService()) || this.getAddress() != null && this.getAddress().length() != 0 && !this.getAddress().equals("*") && !this.getAddress().equals("0.0.0.0") && !this.getAddress().equals(consumer.getAddress()) || this.getApplication() != null && this.getApplication().length() != 0 && !this.getApplication().equals("*") && !this.getApplication().equals(consumer.getApplication()));
    }

    public Map<String, String> toParametersMap() {
        Map map = StringUtils.parseQueryString((String)this.getParams());
        map.remove("interface");
        map.remove("group");
        map.remove("version");
        map.remove("application");
        map.remove("category");
        map.remove("dynamic");
        map.remove("enabled");
        return map;
    }

    public URL toUrl() {
        String group = null;
        String version = null;
        String path = this.service;
        int i = path.indexOf("/");
        if (i > 0) {
            group = path.substring(0, i);
            path = path.substring(i + 1);
        }
        if ((i = path.lastIndexOf(":")) > 0) {
            version = path.substring(i + 1);
            path = path.substring(0, i);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("override");
        sb.append("://");
        if (!StringUtils.isBlank((String)this.address) && !"*".equals(this.address)) {
            sb.append(this.address);
        } else {
            sb.append("0.0.0.0");
        }
        sb.append("/");
        sb.append(path);
        sb.append("?");
        Map param = StringUtils.parseQueryString((String)this.params);
        param.put("category", "configurators");
        param.put("enabled", String.valueOf(this.isEnabled()));
        param.put("dynamic", "false");
        if (!StringUtils.isBlank((String)this.application) && !"*".equals(this.application)) {
            param.put("application", this.application);
        }
        if (group != null) {
            param.put("group", group);
        }
        if (version != null) {
            param.put("version", version);
        }
        sb.append(StringUtils.toQueryString((Map)param));
        return URL.valueOf((String)sb.toString());
    }
}

