/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import java.util.concurrent.Executor;

class Backgrounding {
    private final boolean inBackground;
    private final Object context;
    private final BackgroundCallback callback;

    Backgrounding(Object object) {
        this.inBackground = true;
        this.context = object;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback backgroundCallback) {
        this.inBackground = true;
        this.context = null;
        this.callback = backgroundCallback;
    }

    Backgrounding(boolean bl) {
        this.inBackground = bl;
        this.context = null;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback backgroundCallback, Object object) {
        this.inBackground = true;
        this.context = object;
        this.callback = backgroundCallback;
    }

    Backgrounding(CuratorFrameworkImpl curatorFrameworkImpl, BackgroundCallback backgroundCallback, Object object, Executor executor) {
        this(Backgrounding.wrapCallback(curatorFrameworkImpl, backgroundCallback, executor), object);
    }

    Backgrounding(CuratorFrameworkImpl curatorFrameworkImpl, BackgroundCallback backgroundCallback, Executor executor) {
        this(Backgrounding.wrapCallback(curatorFrameworkImpl, backgroundCallback, executor));
    }

    Backgrounding() {
        this.inBackground = false;
        this.context = null;
        this.callback = null;
    }

    boolean inBackground() {
        return this.inBackground;
    }

    Object getContext() {
        return this.context;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    private static BackgroundCallback wrapCallback(final CuratorFrameworkImpl curatorFrameworkImpl, final BackgroundCallback backgroundCallback, final Executor executor) {
        return new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework curatorFramework, final CuratorEvent curatorEvent) throws Exception {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            backgroundCallback.processResult(curatorFrameworkImpl, curatorEvent);
                        }
                        catch (Exception exception) {
                            curatorFrameworkImpl.logError("Background operation result handling threw exception", exception);
                        }
                    }
                });
            }
        };
    }
}

