/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.ACLBackgroundPathAndBytesable;
import com.netflix.curator.framework.api.ACLCreateModePathAndBytesable;
import com.netflix.curator.framework.api.ACLPathAndBytesable;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.CreateBackgroundModeACLable;
import com.netflix.curator.framework.api.CreateBuilder;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.PathAndBytesable;
import com.netflix.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import com.netflix.curator.framework.api.transaction.CuratorTransactionBridge;
import com.netflix.curator.framework.api.transaction.OperationType;
import com.netflix.curator.framework.api.transaction.TransactionCreateBuilder;
import com.netflix.curator.framework.imps.ACLing;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.CuratorMultiTransactionRecord;
import com.netflix.curator.framework.imps.CuratorTransactionImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.PathAndBytes;
import com.netflix.curator.utils.ZKPaths;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

class CreateBuilderImpl
implements CreateBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean doProtected;
    private boolean compress;
    private String protectedId;
    private ACLing acling;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    static final String PROTECTED_PREFIX = "_c_";

    CreateBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(curatorFrameworkImpl.getAclProvider());
        this.createParentsIfNeeded = false;
        this.compress = false;
        this.doProtected = false;
        this.protectedId = null;
    }

    TransactionCreateBuilder asTransactionCreateBuilder(final CuratorTransactionImpl curatorTransactionImpl, final CuratorMultiTransactionRecord curatorMultiTransactionRecord) {
        return new TransactionCreateBuilder(){

            @Override
            public PathAndBytesable<CuratorTransactionBridge> withACL(List<ACL> list) {
                CreateBuilderImpl.this.withACL((List)list);
                return this;
            }

            @Override
            public ACLPathAndBytesable<CuratorTransactionBridge> withMode(CreateMode createMode) {
                CreateBuilderImpl.this.withMode(createMode);
                return this;
            }

            @Override
            public CuratorTransactionBridge forPath(String string) throws Exception {
                return this.forPath(string, CreateBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public CuratorTransactionBridge forPath(String string, byte[] byArray) throws Exception {
                String string2 = CreateBuilderImpl.this.client.fixForNamespace(string);
                curatorMultiTransactionRecord.add(Op.create((String)string2, (byte[])byArray, CreateBuilderImpl.this.acling.getAclList(string), (CreateMode)CreateBuilderImpl.this.createMode), OperationType.CREATE, string);
                return curatorTransactionImpl;
            }
        };
    }

    @Override
    public CreateBackgroundModeACLable compressed() {
        this.compress = true;
        return new CreateBackgroundModeACLable(){

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> list) {
                return CreateBuilderImpl.this.withACL((List)list);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, object);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, object, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object object) {
                return CreateBuilderImpl.this.inBackground(object);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode createMode) {
                return CreateBuilderImpl.this.withMode(createMode);
            }

            @Override
            public String forPath(String string, byte[] byArray) throws Exception {
                return CreateBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public String forPath(String string) throws Exception {
                return CreateBuilderImpl.this.forPath(string);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> list) {
        this.acling = new ACLing(this.client.getAclProvider(), list);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> list) {
                return CreateBuilderImpl.this.withACL((List)list);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, object);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, object, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(Object object) {
                return CreateBuilderImpl.this.inBackground(object);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(backgroundCallback, executor);
            }

            @Override
            public String forPath(String string, byte[] byArray) throws Exception {
                return CreateBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public String forPath(String string) throws Exception {
                return CreateBuilderImpl.this.forPath(string);
            }
        };
    }

    @Override
    public ProtectACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ProtectACLCreateModePathAndBytesable<String>(){

            @Override
            public ACLCreateModePathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public PathAndBytesable<String> withACL(List<ACL> list) {
                return CreateBuilderImpl.this.withACL((List)list);
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode createMode) {
                CreateBuilderImpl.this.createMode = createMode;
                return this;
            }

            @Override
            public String forPath(String string, byte[] byArray) throws Exception {
                return CreateBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public String forPath(String string) throws Exception {
                return CreateBuilderImpl.this.forPath(string);
            }
        };
    }

    @Override
    public ACLCreateModePathAndBytesable<String> withProtection() {
        this.setProtected();
        return this.asACLCreateModePathAndBytesable();
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.setProtected();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> list) {
                return CreateBuilderImpl.this.withACL((List)list);
            }

            @Override
            public String forPath(String string, byte[] byArray) throws Exception {
                return CreateBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public String forPath(String string) throws Exception {
                return CreateBuilderImpl.this.forPath(string);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object) {
        this.backgrounding = new Backgrounding(backgroundCallback, object);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, object, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public String forPath(String string) throws Exception {
        return this.forPath(string, this.client.getDefaultData());
    }

    @Override
    public String forPath(String string, byte[] byArray) throws Exception {
        if (this.compress) {
            byArray = this.client.getCompressionProvider().compress(string, byArray);
        }
        string = this.client.fixForNamespace(string);
        String string2 = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(string, byArray), this.backgrounding.getCallback(), null), null);
        } else {
            string2 = this.pathInForeground(string, byArray);
            string2 = this.client.unfixForNamespace(string2);
        }
        return string2;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Background");
        this.client.getZooKeeper().create(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, new AsyncCallback.StringCallback(){

            public void processResult(int n, String string, Object object, String string2) {
                string = CreateBuilderImpl.this.client.unfixForNamespace(string);
                string2 = CreateBuilderImpl.this.client.unfixForNamespace(string2);
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(CreateBuilderImpl.this.client, CuratorEventType.CREATE, n, string, string2, object, null, null, null, null, null);
                CreateBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        }, this.backgrounding.getContext());
    }

    private void setProtected() {
        this.doProtected = true;
        this.protectedId = UUID.randomUUID().toString();
    }

    private ACLCreateModePathAndBytesable<String> asACLCreateModePathAndBytesable() {
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> list) {
                return CreateBuilderImpl.this.withACL((List)list);
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode createMode) {
                CreateBuilderImpl.this.createMode = createMode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> list) {
                        return CreateBuilderImpl.this.withACL((List)list);
                    }

                    @Override
                    public String forPath(String string, byte[] byArray) throws Exception {
                        return CreateBuilderImpl.this.forPath(string, byArray);
                    }

                    @Override
                    public String forPath(String string) throws Exception {
                        return CreateBuilderImpl.this.forPath(string);
                    }
                };
            }

            @Override
            public String forPath(String string, byte[] byArray) throws Exception {
                return CreateBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public String forPath(String string) throws Exception {
                return CreateBuilderImpl.this.forPath(string);
            }
        };
    }

    private String pathInForeground(final String string, final byte[] byArray) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        String string2 = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean bl = atomicBoolean.getAndSet(false);
                String string3 = CreateBuilderImpl.this.adjustPath(string);
                String string2 = null;
                if (!bl && CreateBuilderImpl.this.doProtected) {
                    string2 = CreateBuilderImpl.this.findProtectedNodeInForeground(string3);
                }
                if (string2 == null) {
                    try {
                        string2 = CreateBuilderImpl.this.client.getZooKeeper().create(string3, byArray, CreateBuilderImpl.this.acling.getAclList(string3), CreateBuilderImpl.this.createMode);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        if (CreateBuilderImpl.this.createParentsIfNeeded) {
                            ZKPaths.mkdirs((ZooKeeper)CreateBuilderImpl.this.client.getZooKeeper(), (String)string3, (boolean)false);
                            string2 = CreateBuilderImpl.this.client.getZooKeeper().create(string3, byArray, CreateBuilderImpl.this.acling.getAclList(string3), CreateBuilderImpl.this.createMode);
                        }
                        throw noNodeException;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return string2;
            }
        });
        timeTrace.commit();
        return string2;
    }

    private String findProtectedNodeInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String string2 = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string3 = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)string);
                    List list = CreateBuilderImpl.this.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    final String string2 = CreateBuilderImpl.this.getProtectedPrefix();
                    string3 = (String)Iterables.find((Iterable)list, (Predicate)new Predicate<String>(){

                        public boolean apply(String string) {
                            return string.startsWith(string2);
                        }
                    }, null);
                    if (string3 != null) {
                        string3 = ZKPaths.makePath((String)pathAndNode.getPath(), (String)string3);
                    }
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return string3;
            }
        });
        timeTrace.commit();
        return string2;
    }

    private String adjustPath(String string) throws Exception {
        if (this.doProtected) {
            ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)string);
            String string2 = this.getProtectedPrefix() + pathAndNode.getNode();
            string = ZKPaths.makePath((String)pathAndNode.getPath(), (String)string2);
        }
        return string;
    }

    private String getProtectedPrefix() throws Exception {
        return PROTECTED_PREFIX + this.protectedId + "-";
    }
}

