/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.CreateBuilder;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorListener;
import com.netflix.curator.framework.api.DeleteBuilder;
import com.netflix.curator.framework.api.ExistsBuilder;
import com.netflix.curator.framework.api.GetACLBuilder;
import com.netflix.curator.framework.api.GetChildrenBuilder;
import com.netflix.curator.framework.api.GetDataBuilder;
import com.netflix.curator.framework.api.SetACLBuilder;
import com.netflix.curator.framework.api.SetDataBuilder;
import com.netflix.curator.framework.api.UnhandledErrorListener;
import com.netflix.curator.framework.imps.CreateBuilderImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.DeleteBuilderImpl;
import com.netflix.curator.framework.imps.ExistsBuilderImpl;
import com.netflix.curator.framework.imps.GetChildrenBuilderImpl;
import com.netflix.curator.framework.imps.GetDataBuilderImpl;
import com.netflix.curator.framework.imps.NamespaceImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.SetDataBuilderImpl;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.utils.EnsurePath;
import org.apache.zookeeper.ZooKeeper;

class NamespaceFacade
extends CuratorFrameworkImpl {
    private final CuratorFrameworkImpl client;
    private final NamespaceImpl namespace;

    NamespaceFacade(CuratorFrameworkImpl curatorFrameworkImpl, String string) {
        super(curatorFrameworkImpl);
        this.client = curatorFrameworkImpl;
        this.namespace = new NamespaceImpl(curatorFrameworkImpl, string);
    }

    @Override
    public CuratorFramework nonNamespaceView() {
        return this.usingNamespace(null);
    }

    @Override
    public CuratorFramework usingNamespace(String string) {
        return this.client.getNamespaceFacadeCache().get(string);
    }

    @Override
    public String getNamespace() {
        return this.namespace.getNamespace();
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreateBuilder create() {
        return new CreateBuilderImpl(this);
    }

    @Override
    public DeleteBuilder delete() {
        return new DeleteBuilderImpl(this);
    }

    @Override
    public ExistsBuilder checkExists() {
        return new ExistsBuilderImpl(this);
    }

    @Override
    public GetDataBuilder getData() {
        return new GetDataBuilderImpl(this);
    }

    @Override
    public SetDataBuilder setData() {
        return new SetDataBuilderImpl(this);
    }

    @Override
    public GetChildrenBuilder getChildren() {
        return new GetChildrenBuilderImpl(this);
    }

    @Override
    public boolean isStarted() {
        return this.client.isStarted();
    }

    @Override
    public GetACLBuilder getACL() {
        return this.client.getACL();
    }

    @Override
    public SetACLBuilder setACL() {
        return this.client.setACL();
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        return this.client.getCuratorListenable();
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.client.getUnhandledErrorListenable();
    }

    @Override
    public void sync(String string, Object object) {
        this.internalSync(this, string, object);
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client.getZookeeperClient();
    }

    @Override
    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    @Override
    ZooKeeper getZooKeeper() throws Exception {
        return this.client.getZooKeeper();
    }

    @Override
    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent curatorEvent) {
        this.client.processBackgroundOperation(operationAndData, curatorEvent);
    }

    @Override
    void logError(String string, Throwable throwable) {
        this.client.logError(string, throwable);
    }

    @Override
    String unfixForNamespace(String string) {
        return this.namespace.unfixForNamespace(string);
    }

    @Override
    String fixForNamespace(String string) {
        return this.namespace.fixForNamespace(string);
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String string) {
        return this.namespace.newNamespaceAwareEnsurePath(string);
    }
}

