/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.NamespaceFacade;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class NamespaceFacadeCache {
    private final CuratorFrameworkImpl client;
    private final NamespaceFacade nullNamespace;
    private final CacheLoader<String, NamespaceFacade> loader = new CacheLoader<String, NamespaceFacade>(){

        public NamespaceFacade load(String string) throws Exception {
            return new NamespaceFacade(NamespaceFacadeCache.this.client, string);
        }
    };
    private final LoadingCache<String, NamespaceFacade> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.loader);

    NamespaceFacadeCache(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.nullNamespace = new NamespaceFacade(curatorFrameworkImpl, null);
    }

    NamespaceFacade get(String string) {
        try {
            return string != null ? (NamespaceFacade)this.cache.get((Object)string) : this.nullNamespace;
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
    }
}

