/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.api.CuratorWatcher;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.NamespaceWatchedEvent;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class NamespaceWatcher
implements Watcher {
    private final CuratorFrameworkImpl client;
    private final Watcher actualWatcher;
    private final CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl curatorFrameworkImpl, Watcher watcher) {
        this.client = curatorFrameworkImpl;
        this.actualWatcher = watcher;
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl curatorFrameworkImpl, CuratorWatcher curatorWatcher) {
        this.client = curatorFrameworkImpl;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
    }

    public void process(WatchedEvent watchedEvent) {
        if (this.actualWatcher != null) {
            this.actualWatcher.process((WatchedEvent)new NamespaceWatchedEvent(this.client, watchedEvent));
        } else if (this.curatorWatcher != null) {
            try {
                this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, watchedEvent));
            }
            catch (Exception exception) {
                this.client.logError("Watcher exception", exception);
            }
        }
    }
}

