/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.curator.RetrySleeper;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.imps.BackgroundOperation;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class OperationAndData<T>
implements Delayed,
RetrySleeper {
    private static final AtomicLong nextOrdinal = new AtomicLong();
    private final BackgroundOperation<T> operation;
    private final T data;
    private final BackgroundCallback callback;
    private final long startTimeMs = System.currentTimeMillis();
    private final ErrorCallback<T> errorCallback;
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final AtomicLong sleepUntilTimeMs = new AtomicLong(0L);
    private final long ordinal = nextOrdinal.getAndIncrement();

    OperationAndData(BackgroundOperation<T> backgroundOperation, T t, BackgroundCallback backgroundCallback, ErrorCallback<T> errorCallback) {
        this.operation = backgroundOperation;
        this.data = t;
        this.callback = backgroundCallback;
        this.errorCallback = errorCallback;
    }

    void callPerformBackgroundOperation() throws Exception {
        this.operation.performBackgroundOperation(this);
    }

    T getData() {
        return this.data;
    }

    long getElapsedTimeMs() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    int getThenIncrementRetryCount() {
        return this.retryCount.getAndIncrement();
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    ErrorCallback<T> getErrorCallback() {
        return this.errorCallback;
    }

    @VisibleForTesting
    BackgroundOperation<T> getOperation() {
        return this.operation;
    }

    public void sleepFor(long l, TimeUnit timeUnit) throws InterruptedException {
        this.sleepUntilTimeMs.set(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(l, timeUnit));
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.sleepUntilTimeMs.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        long l = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        if (l == 0L && delayed instanceof OperationAndData) {
            l = this.ordinal - ((OperationAndData)delayed).ordinal;
        }
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    static interface ErrorCallback<T> {
        public void retriesExhausted(OperationAndData<T> var1);
    }
}

