/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Slowlog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jedis
extends BinaryJedis
implements JedisCommands {
    public Jedis(String host) {
        super(host);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    @Override
    public String ping() {
        this.checkIsInMulti();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value) {
        this.checkIsInMulti();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.checkIsInMulti();
        this.client.sendCommand(Protocol.Command.GET, key);
        return this.client.getBulkReply();
    }

    @Override
    public String quit() {
        this.checkIsInMulti();
        this.client.quit();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean exists(String key) {
        this.checkIsInMulti();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    public Long del(String ... keys) {
        this.checkIsInMulti();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.checkIsInMulti();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMulti();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    public Set<String> keys(String pattern) {
        this.checkIsInMulti();
        this.client.keys(pattern);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    public String randomKey() {
        this.checkIsInMulti();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    public String rename(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public Long renamenx(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, int seconds) {
        this.checkIsInMulti();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.checkIsInMulti();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.checkIsInMulti();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.checkIsInMulti();
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    public Long move(String key, int dbIndex) {
        this.checkIsInMulti();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMulti();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.checkIsInMulti();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    public List<String> mget(String ... keys) {
        this.checkIsInMulti();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value) {
        this.checkIsInMulti();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, int seconds, String value) {
        this.checkIsInMulti();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public Long msetnx(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, long integer) {
        this.checkIsInMulti();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.checkIsInMulti();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, long integer) {
        this.checkIsInMulti();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incr(String key) {
        this.checkIsInMulti();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.checkIsInMulti();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field) {
        this.checkIsInMulti();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMulti();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMulti();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        this.checkIsInMulti();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.checkIsInMulti();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        this.checkIsInMulti();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.checkIsInMulti();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.checkIsInMulti();
        this.client.hkeys(key);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.checkIsInMulti();
        this.client.hvals(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.checkIsInMulti();
        this.client.hgetAll(key);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(String key, String ... strings) {
        this.checkIsInMulti();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String ... strings) {
        this.checkIsInMulti();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.checkIsInMulti();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, long index) {
        this.checkIsInMulti();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, long index, String value) {
        this.checkIsInMulti();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, long count, String value) {
        this.checkIsInMulti();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.checkIsInMulti();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.checkIsInMulti();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMulti();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String ... members) {
        this.checkIsInMulti();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.checkIsInMulti();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        return new HashSet<String>(members);
    }

    @Override
    public Long srem(String key, String ... members) {
        this.checkIsInMulti();
        this.client.srem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.checkIsInMulti();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    public Long smove(String srckey, String dstkey, String member) {
        this.checkIsInMulti();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.checkIsInMulti();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.checkIsInMulti();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    public Set<String> sinter(String ... keys) {
        this.checkIsInMulti();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new HashSet<String>(members);
    }

    public Long sinterstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sunion(String ... keys) {
        this.checkIsInMulti();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new HashSet<String>(members);
    }

    public Long sunionstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sdiff(String ... keys) {
        this.checkIsInMulti();
        this.client.sdiff(keys);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.checkIsInMulti();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<Double, String> scoreMembers) {
        this.checkIsInMulti();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long zrem(String key, String ... members) {
        this.checkIsInMulti();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Long zcard(String key) {
        this.checkIsInMulti();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.checkIsInMulti();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.checkIsInMulti();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    public List<String> blpop(int timeout, String ... keys) {
        this.checkIsInMulti();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.blpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    public Long sort(String key, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    public List<String> brpop(int timeout, String ... keys) {
        this.checkIsInMulti();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.brpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public String auth(String password) {
        this.checkIsInMulti();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.checkIsInMulti();
        this.connect();
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    @Override
    public Long publish(String channel, String message) {
        this.checkIsInMulti();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.checkIsInMulti();
        this.connect();
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    @Override
    public Long zcount(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    private Set<Tuple> getTupledSet() {
        this.checkIsInMulti();
        List<String> membersWithScores = this.client.getMultiBulkReply();
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(iterator.next())));
        }
        return set;
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Long strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpushx(String key, String string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    public Long persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(String key, String string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    public String brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        String reply = this.client.getBulkReply();
        this.client.rollbackTimeout();
        return reply;
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(String key, long offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    public String configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    public Object eval(String script, int keyCount, String ... params) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, keyCount, params);
        return this.getEvalResult();
    }

    private String[] getParams(List<String> keys, List<String> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        String[] params = new String[keyCount + args.size()];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        return this.eval(script, keys.size(), this.getParams(keys, args));
    }

    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    public Object evalsha(String script) {
        return this.evalsha(script, 0, new String[0]);
    }

    private Object getEvalResult() {
        Object result = this.client.getOne();
        if (result instanceof byte[]) {
            return SafeEncoder.encode((byte[])result);
        }
        if (result instanceof List) {
            List list = (List)result;
            ArrayList<String> listResult = new ArrayList<String>(list.size());
            for (Object bin : list) {
                listResult.add(SafeEncoder.encode((byte[])bin));
            }
            return listResult;
        }
        return result;
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.evalsha(sha1, keys.size(), this.getParams(keys, args));
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        this.checkIsInMulti();
        this.client.evalsha(sha1, keyCount, params);
        return this.getEvalResult();
    }

    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    public List<Boolean> scriptExists(String ... sha1) {
        this.client.scriptExists(sha1);
        List<Long> result = this.client.getIntegerMultiBulkReply();
        ArrayList<Boolean> exists = new ArrayList<Boolean>();
        for (Long value : result) {
            exists.add(value == 1L);
        }
        return exists;
    }

    public String scriptLoad(String script) {
        this.client.scriptLoad(script);
        return this.client.getBulkReply();
    }

    public List<Slowlog> slowlogGet() {
        this.client.slowlogGet();
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    public List<Slowlog> slowlogGet(long entries) {
        this.client.slowlogGet(entries);
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    public Long objectRefcount(String string) {
        this.client.objectRefcount(string);
        return this.client.getIntegerReply();
    }

    public String objectEncoding(String string) {
        this.client.objectEncoding(string);
        return this.client.getBulkReply();
    }

    public Long objectIdletime(String string) {
        this.client.objectIdletime(string);
        return this.client.getIntegerReply();
    }
}

