/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.auth;

import javax.security.auth.callback.CallbackHandler;
import net.rubyeye.xmemcached.auth.PlainCallbackHandler;

public class AuthInfo {
    private final CallbackHandler callbackHandler;
    private final String[] mechanisms;
    private final int maxAttempts = Integer.parseInt(System.getProperty("net.rubyeye.xmemcached.auth_max_attempts", "-1"));
    private int attempts;

    public synchronized boolean isValid() {
        return this.attempts <= this.maxAttempts || this.maxAttempts < 0;
    }

    public synchronized boolean isFirstTime() {
        return this.attempts == 0;
    }

    public synchronized void increaseAttempts() {
        ++this.attempts;
    }

    public AuthInfo(CallbackHandler callbackHandler, String[] mechanisms) {
        this.callbackHandler = callbackHandler;
        this.mechanisms = mechanisms;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public static AuthInfo plain(String username, String password) {
        return new AuthInfo(new PlainCallbackHandler(username, password), new String[]{"PLAIN"});
    }

    public static AuthInfo cramMD5(String username, String password) {
        return new AuthInfo(new PlainCallbackHandler(username, password), new String[]{"CRAM-MD5"});
    }

    public static AuthInfo typical(String username, String password) {
        return new AuthInfo(new PlainCallbackHandler(username, password), new String[]{"CRAM-MD5", "PLAIN"});
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public String[] getMechanisms() {
        return this.mechanisms;
    }
}

