/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;

public final class LeaderFollowerNIOStrategy
extends AbstractIOStrategy {
    private static final LeaderFollowerNIOStrategy INSTANCE = new LeaderFollowerNIOStrategy();
    private static final Logger logger = Grizzly.logger(LeaderFollowerNIOStrategy.class);

    private LeaderFollowerNIOStrategy() {
    }

    public static LeaderFollowerNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        IOEventProcessingHandler ph = null;
        if (LeaderFollowerNIOStrategy.isReadWrite(ioEvent)) {
            nioConnection.disableIOEvent(ioEvent);
            ph = enableInterestProcessingHandler;
        }
        if (LeaderFollowerNIOStrategy.isExecuteInWorkerThread(ioEvent)) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            LeaderFollowerNIOStrategy.getWorkerThreadPool(connection).execute(runner);
            LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
            return false;
        }
        LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
        return true;
    }
}

