/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.monitor.MemcachedClientNameHolder;
import net.rubyeye.xmemcached.monitor.StatisticsHandlerMBean;
import net.rubyeye.xmemcached.monitor.XMemcachedMbeanServer;

public class StatisticsHandler
implements StatisticsHandlerMBean {
    private Map<CommandType, AtomicLong> counterMap = new HashMap<CommandType, AtomicLong>();
    private boolean statistics = Boolean.valueOf(System.getProperty("xmemcached.statistics.enable", "false"));

    public StatisticsHandler() {
        this.buildCounterMap();
        XMemcachedMbeanServer.getInstance().registMBean(this, this.getClass().getPackage().getName() + ":type=" + this.getClass().getSimpleName() + "-" + MemcachedClientNameHolder.getName());
    }

    private void buildCounterMap() {
        if (this.statistics) {
            HashMap<CommandType, AtomicLong> map = new HashMap<CommandType, AtomicLong>();
            map.put(CommandType.APPEND, new AtomicLong());
            map.put(CommandType.SET, new AtomicLong());
            map.put(CommandType.PREPEND, new AtomicLong());
            map.put(CommandType.CAS, new AtomicLong());
            map.put(CommandType.ADD, new AtomicLong());
            map.put(CommandType.REPLACE, new AtomicLong());
            map.put(CommandType.DELETE, new AtomicLong());
            map.put(CommandType.INCR, new AtomicLong());
            map.put(CommandType.DECR, new AtomicLong());
            map.put(CommandType.GET_HIT, new AtomicLong());
            map.put(CommandType.GET_MISS, new AtomicLong());
            map.put(CommandType.GET_MANY, new AtomicLong());
            map.put(CommandType.GETS_MANY, new AtomicLong());
            this.counterMap = map;
        }
    }

    public final boolean isStatistics() {
        return this.statistics;
    }

    public final void statistics(CommandType cmdType) {
        if (this.statistics && this.counterMap.get((Object)cmdType) != null) {
            this.counterMap.get((Object)cmdType).incrementAndGet();
        }
    }

    public final void statistics(CommandType cmdType, int count) {
        if (this.statistics && this.counterMap.get((Object)cmdType) != null) {
            this.counterMap.get((Object)cmdType).addAndGet(count);
        }
    }

    public final void setStatistics(boolean statistics) {
        this.statistics = statistics;
        this.buildCounterMap();
    }

    public long getAppendCount() {
        return this.counterMap.get((Object)CommandType.APPEND).get();
    }

    public long getCASCount() {
        return this.counterMap.get((Object)CommandType.CAS).get();
    }

    public long getDecrCount() {
        return this.counterMap.get((Object)CommandType.DECR).get();
    }

    public long getDeleteCount() {
        return this.counterMap.get((Object)CommandType.DELETE).get();
    }

    public long getGetHitCount() {
        return this.counterMap.get((Object)CommandType.GET_HIT).get();
    }

    public long getGetMissCount() {
        return this.counterMap.get((Object)CommandType.GET_MISS).get();
    }

    public long getIncrCount() {
        return this.counterMap.get((Object)CommandType.INCR).get();
    }

    public long getMultiGetCount() {
        return this.counterMap.get((Object)CommandType.GET_MANY).get();
    }

    public long getMultiGetsCount() {
        return this.counterMap.get((Object)CommandType.GETS_MANY).get();
    }

    public long getPrependCount() {
        return this.counterMap.get((Object)CommandType.PREPEND).get();
    }

    public long getSetCount() {
        return this.counterMap.get((Object)CommandType.SET).get();
    }

    public long getAddCount() {
        return this.counterMap.get((Object)CommandType.ADD).get();
    }

    public long getReplaceCount() {
        return this.counterMap.get((Object)CommandType.REPLACE).get();
    }
}

