/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.collect.ImmutableList;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.NamespaceWatchedEvent;
import java.util.List;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class CuratorEventImpl
implements CuratorEvent {
    private final CuratorEventType type;
    private final int resultCode;
    private final String path;
    private final String name;
    private final List<String> children;
    private final Object context;
    private final Stat stat;
    private final byte[] data;
    private final WatchedEvent watchedEvent;
    private final List<ACL> aclList;

    @Override
    public CuratorEventType getType() {
        return this.type;
    }

    @Override
    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public Stat getStat() {
        return this.stat;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }

    @Override
    public WatchedEvent getWatchedEvent() {
        return this.watchedEvent;
    }

    @Override
    public List<ACL> getACLList() {
        return this.aclList;
    }

    CuratorEventImpl(CuratorFrameworkImpl curatorFrameworkImpl, CuratorEventType curatorEventType, int n, String string, String string2, Object object, Stat stat, byte[] byArray, List<String> list, WatchedEvent watchedEvent, List<ACL> list2) {
        this.type = curatorEventType;
        this.resultCode = n;
        this.path = curatorFrameworkImpl.unfixForNamespace(string);
        this.name = string2;
        this.context = object;
        this.stat = stat;
        this.data = byArray;
        this.children = list;
        this.watchedEvent = watchedEvent != null ? new NamespaceWatchedEvent(curatorFrameworkImpl, watchedEvent) : watchedEvent;
        this.aclList = list2 != null ? ImmutableList.copyOf(list2) : null;
    }
}

