/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.GetACLBuilder;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class GetACLBuilderImpl
implements GetACLBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetACLBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.backgrounding = new Backgrounding();
        this.responseStat = null;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback backgroundCallback, Object object) {
        this.backgrounding = new Backgrounding(backgroundCallback, object);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, object, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetACLBuilderImpl-Background");
        AsyncCallback.ACLCallback aCLCallback = new AsyncCallback.ACLCallback(){

            public void processResult(int n, String string, Object object, List<ACL> list, Stat stat) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(GetACLBuilderImpl.this.client, CuratorEventType.GET_ACL, n, string, null, object, stat, null, null, null, list);
                GetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        };
        this.client.getZooKeeper().getACL(operationAndData.getData(), this.responseStat, aCLCallback, this.backgrounding.getContext());
    }

    @Override
    public List<ACL> forPath(String string) throws Exception {
        string = this.client.fixForNamespace(string);
        List<ACL> list = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), null), null);
        } else {
            list = this.pathInForeground(string);
        }
        return list;
    }

    private List<ACL> pathInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetACLBuilderImpl-Foreground");
        List list = (List)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<List<ACL>>(){

            @Override
            public List<ACL> call() throws Exception {
                return GetACLBuilderImpl.this.client.getZooKeeper().getACL(string, GetACLBuilderImpl.this.responseStat);
            }
        });
        timeTrace.commit();
        return list;
    }
}

